/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.support.SchemaSet;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtil {
    public static final String DEFAULT_LOCATION_PREFIX = "http://localhost:8080/schema/";
    private static final String SPRINGEXT_BASE_URI = "http://www.alibaba.com/schema/springext/base";
    private static final String SPRINGEXT_BASE_XSD = "http://www.alibaba.com/schema/springext/springext-base.xsd";
    private static final Namespace XSD = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ANY = DocumentHelper.createQName((String)"any", (Namespace)XSD);
    private static final QName XSD_IMPORT = DocumentHelper.createQName((String)"import", (Namespace)XSD);
    private static final QName XSD_CHOICE = DocumentHelper.createQName((String)"choice", (Namespace)XSD);
    private static final QName XSD_ELEMENT = DocumentHelper.createQName((String)"element", (Namespace)XSD);
    private static final QName XSD_INCLUDE = DocumentHelper.createQName((String)"include", (Namespace)XSD);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(InputStream istream, String systemId, boolean close) throws DocumentException {
        SAXReader reader = new SAXReader(false);
        Document doc = null;
        try {
            doc = reader.read(istream, systemId);
        }
        finally {
            if (close && istream != null) {
                try {
                    istream.close();
                }
                catch (Exception e) {}
            }
        }
        return doc;
    }

    public static String getDocumentText(Document doc, String charset) {
        StringWriter writer = new StringWriter();
        try {
            SchemaUtil.writeDocument(doc, writer, charset);
        }
        catch (IOException e) {
            Assert.unexpectedException(e);
        }
        return writer.toString();
    }

    public static byte[] getDocumentContent(Document doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SchemaUtil.writeDocument(doc, baos, null);
        }
        catch (IOException e) {
            Assert.unexpectedException(e);
        }
        return baos.toByteArray();
    }

    public static void writeDocument(Document doc, OutputStream stream, String charset) throws IOException {
        charset = StringUtil.defaultIfEmpty(StringUtil.trimToNull(charset), "UTF-8");
        SchemaUtil.writeDocument(doc, new OutputStreamWriter(stream, charset), charset);
    }

    public static void writeDocument(Document doc, Writer writer, String charset) throws IOException {
        charset = StringUtil.defaultIfEmpty(StringUtil.trimToNull(charset), "UTF-8");
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(charset);
        format.setIndent(true);
        format.setIndentSize(4);
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    public static Document createConfigurationPointSchema(ConfigurationPoint configurationPoint, String version) {
        Document doc = DocumentHelper.createDocument();
        Element schemaRoot = doc.addElement("xsd:schema", "http://www.w3.org/2001/XMLSchema");
        schemaRoot.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        schemaRoot.addNamespace("beans", "http://www.springframework.org/schema/beans");
        schemaRoot.addNamespace("springext", SPRINGEXT_BASE_URI);
        schemaRoot.addNamespace("", configurationPoint.getNamespaceUri());
        schemaRoot.addAttribute("targetNamespace", configurationPoint.getNamespaceUri());
        schemaRoot.addAttribute("elementFormDefault", "qualified");
        TreeSet<String> includings = CollectionUtil.createTreeSet();
        for (Contribution contrib : configurationPoint.getContributions()) {
            Schema contribSchema = contrib.getSchemas().getVersionedSchema(version);
            if (contribSchema == null) {
                contribSchema = contrib.getSchemas().getMainSchema();
            }
            if (contribSchema == null) continue;
            includings.add(contribSchema.getName());
        }
        for (String including : includings) {
            Element includeElement = schemaRoot.addElement("xsd:include");
            includeElement.addAttribute("schemaLocation", including);
        }
        if (configurationPoint.getDefaultElementName() != null) {
            Element importBeans = schemaRoot.addElement("xsd:import");
            importBeans.addAttribute("namespace", "http://www.springframework.org/schema/beans");
            importBeans.addAttribute("schemaLocation", "http://www.springframework.org/schema/beans/spring-beans.xsd");
            Element importSpringextBase = schemaRoot.addElement("xsd:import");
            importSpringextBase.addAttribute("namespace", SPRINGEXT_BASE_URI);
            importSpringextBase.addAttribute("schemaLocation", SPRINGEXT_BASE_XSD);
            Element element = schemaRoot.addElement("xsd:element");
            element.addAttribute("name", configurationPoint.getDefaultElementName());
            element.addAttribute("type", "springext:referenceableBeanType");
        }
        return doc;
    }

    public static Schema.Transformer getContributionSchemaTransformer(ConfigurationPoints cps, final Contribution thisContrib) {
        return new AnyElementTransformer(cps){
            private final ConfigurationPoint thisCp;
            {
                super(x0);
                this.thisCp = thisContrib.getConfigurationPoint();
            }

            protected void visitRootElement() {
                this.root.addNamespace("", this.thisCp.getNamespaceUri());
                this.root.addAttribute("targetNamespace", this.thisCp.getNamespaceUri());
            }

            protected boolean canAddImportFor(ConfigurationPoint cp) {
                return this.thisCp != cp;
            }

            protected void visitDependedConfigurationPoint(ConfigurationPoint cp) {
                if (cp instanceof ConfigurationPointImpl) {
                    ((ConfigurationPointImpl)cp).addDependingContribution(thisContrib);
                }
            }
        };
    }

    public static Schema.Transformer getAnyElementTransformer(ConfigurationPoints cps, final AnyElementVisitor visitor) {
        return new AnyElementTransformer(cps){

            protected void visitDependedConfigurationPoint(ConfigurationPoint cp) {
                visitor.visitAnyElement(cp);
            }
        };
    }

    public static Schema.Transformer getTransformerWhoRemovesIncludes() {
        return new Schema.Transformer(){

            public void transform(Document document, String systemId) {
                Element root = document.getRootElement();
                if ("http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) && "schema".equals(root.getName())) {
                    Iterator i = root.elementIterator(XSD_INCLUDE);
                    while (i.hasNext()) {
                        i.next();
                        i.remove();
                    }
                }
            }
        };
    }

    public static Schema.Transformer getTransformerWhoAddsIndirectIncludes(final Map<String, Schema> includes) {
        return new Schema.Transformer(){

            public void transform(Document document, String systemId) {
                Element root = document.getRootElement();
                root.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
                if ("http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) && "schema".equals(root.getName())) {
                    Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
                    QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
                    Iterator i = root.elementIterator(includeName);
                    while (i.hasNext()) {
                        i.next();
                        i.remove();
                    }
                    List nodes = root.elements();
                    int i2 = 0;
                    for (Schema includedSchema : includes.values()) {
                        Element includeElement = DocumentHelper.createElement((QName)includeName);
                        nodes.add(i2++, includeElement);
                        includeElement.addAttribute("schemaLocation", includedSchema.getName());
                    }
                }
            }
        };
    }

    public static Schema.Transformer getAddPrefixTransformer(final SchemaSet schemas, String prefix) {
        if (prefix != null && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        final String normalizedPrefix = prefix;
        return new Schema.Transformer(){

            public void transform(Document document, String systemId) {
                Element root;
                if (normalizedPrefix != null && "http://www.w3.org/2001/XMLSchema".equals((root = document.getRootElement()).getNamespaceURI()) && "schema".equals(root.getName())) {
                    String schemaLocation;
                    Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
                    QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
                    QName importName = DocumentHelper.createQName((String)"import", (Namespace)xsd);
                    Iterator i = root.elementIterator(includeName);
                    while (i.hasNext()) {
                        Element includeElement = (Element)i.next();
                        schemaLocation = StringUtil.trimToNull(includeElement.attributeValue("schemaLocation"));
                        if (schemaLocation == null || (schemaLocation = this.getNewSchemaLocation(schemaLocation, null, systemId)) == null) continue;
                        includeElement.addAttribute("schemaLocation", schemaLocation);
                    }
                    i = root.elementIterator(importName);
                    while (i.hasNext()) {
                        Element importElement = (Element)i.next();
                        schemaLocation = importElement.attributeValue("schemaLocation");
                        String namespace = StringUtil.trimToNull(importElement.attributeValue("namespace"));
                        if (schemaLocation == null && namespace == null || (schemaLocation = this.getNewSchemaLocation(schemaLocation, namespace, systemId)) == null) continue;
                        importElement.addAttribute("schemaLocation", schemaLocation);
                    }
                }
            }

            private String getNewSchemaLocation(String schemaLocation, String namespace, String systemId) {
                Set<Schema> nsSchemas;
                if (schemaLocation != null) {
                    Schema schema = schemas.findSchema(schemaLocation);
                    if (schema != null) {
                        return normalizedPrefix + schema.getName();
                    }
                    return schemaLocation;
                }
                if (namespace != null && (nsSchemas = schemas.getNamespaceMappings().get(namespace)) != null && !nsSchemas.isEmpty()) {
                    String versionedExtension = this.getVersionedExtension(systemId);
                    if (versionedExtension != null) {
                        for (Schema schema : nsSchemas) {
                            if (!schema.getName().endsWith(versionedExtension)) continue;
                            return normalizedPrefix + schema.getName();
                        }
                    }
                    return normalizedPrefix + nsSchemas.iterator().next().getName();
                }
                return null;
            }

            private String getVersionedExtension(String systemId) {
                int slashIndex;
                int dashIndex;
                if (systemId != null && (dashIndex = systemId.lastIndexOf("-")) > (slashIndex = systemId.lastIndexOf("/"))) {
                    return systemId.substring(dashIndex);
                }
                return null;
            }
        };
    }

    public static Schema.Transformer getNoopTransformer() {
        return new Schema.Transformer(){

            public void transform(Document document, String systemId) {
            }
        };
    }

    public static String getNamespacePrefix(String preferredNsPrefix, String targetNamespace) {
        if (preferredNsPrefix != null) {
            return preferredNsPrefix;
        }
        if (targetNamespace != null) {
            return targetNamespace.substring(targetNamespace.lastIndexOf("/") + 1);
        }
        return null;
    }

    public static Map<String, String> parseSchemaLocation(String value) {
        TreeMap<String, String> locations = CollectionUtil.createTreeMap();
        if ((value = StringUtil.trimToNull(value)) != null) {
            String[] values = value.split("\\s+");
            for (int i = 0; i < values.length - 1; i += 2) {
                String uri = StringUtil.trimToNull(values[i]);
                String location = StringUtil.trimToNull(values[i + 1]);
                if (uri == null || location == null) continue;
                locations.put(uri, location);
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatSchemaLocations(Map<String, String> schemaLocations, String qualifiedRootElementName) {
        StringBuilder buf = new StringBuilder();
        Formatter formatter = new Formatter(buf);
        try {
            String leadingSpaces = qualifiedRootElementName.replaceAll(".", " ") + "  ";
            String indent = "    ";
            formatter.format("%n", new Object[0]);
            int maxLength = 0;
            for (String ns : schemaLocations.keySet()) {
                maxLength = Math.max(maxLength, ns.length());
            }
            String format = leadingSpaces + indent + "%-" + maxLength + "s %s%n";
            for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
                String ns = entry.getKey();
                String location = entry.getValue();
                formatter.format(format, ns, location);
            }
            formatter.format(leadingSpaces, new Object[0]);
        }
        finally {
            formatter.close();
        }
        return buf.toString();
    }

    public static String guessLocationPrefix(Map<String, String> schemaLocations, SchemaSet schemas) {
        for (Map.Entry<String, String> entry : schemaLocations.entrySet()) {
            String uri = entry.getKey();
            String location = entry.getValue();
            Set<Schema> schemaSet = schemas.getNamespaceMappings().get(uri);
            if (schemaSet == null) continue;
            for (Schema schema : schemaSet) {
                if (!location.endsWith(schema.getName())) continue;
                String prefix = location.substring(0, location.length() - schema.getName().length());
                try {
                    new URI(prefix);
                    return prefix;
                }
                catch (URISyntaxException ignored) {
                }
            }
        }
        return DEFAULT_LOCATION_PREFIX;
    }

    public static interface AnyElementVisitor {
        public void visitAnyElement(ConfigurationPoint var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AnyElementTransformer
    implements Schema.Transformer {
        protected final ConfigurationPoints cps;
        protected Element root;
        private final Map<String, ConfigurationPoint> importings = CollectionUtil.createHashMap();

        protected AnyElementTransformer(ConfigurationPoints cps) {
            this.cps = cps;
        }

        @Override
        public final void transform(Document document, String systemId) {
            this.root = document.getRootElement();
            if (!"http://www.w3.org/2001/XMLSchema".equals(this.root.getNamespaceURI()) || !"schema".equals(this.root.getName())) {
                return;
            }
            this.visitRootElement();
            this.visitElement(this.root);
            List importElements = this.root.elements(XSD_IMPORT);
            for (Element importElement : importElements) {
                if (importElement.attribute("namespace") == null) continue;
                this.importings.remove(importElement.attribute("namespace").getValue());
            }
            List rootElements = this.root.elements();
            int importIndex = 0;
            for (ConfigurationPoint cp : this.importings.values()) {
                if (!this.canAddImportFor(cp)) continue;
                Element importElement = DocumentHelper.createElement((QName)XSD_IMPORT);
                importElement.addAttribute("namespace", cp.getNamespaceUri());
                importElement.addAttribute("schemaLocation", cp.getSchemas().getMainSchema().getName());
                rootElements.add(importIndex++, importElement);
            }
        }

        protected void visitRootElement() {
        }

        protected boolean canAddImportFor(ConfigurationPoint cp) {
            return true;
        }

        protected abstract void visitDependedConfigurationPoint(ConfigurationPoint var1);

        private void visitElement(Element element) {
            List elements = element.elements();
            this.visitElements(elements);
        }

        private void visitElements(List<Element> elements) {
            LinkedList<Integer> indexes = CollectionUtil.createLinkedList();
            int index = 0;
            for (Element subElement : elements) {
                if (subElement.getQName().equals((Object)XSD_ANY) && subElement.attribute("namespace") != null) {
                    String ns = subElement.attribute("namespace").getValue();
                    ConfigurationPoint cp = this.cps.getConfigurationPointByNamespaceUri(ns);
                    if (cp != null) {
                        indexes.add(index);
                        this.importings.put(ns, cp);
                    }
                    this.visitDependedConfigurationPoint(cp);
                } else {
                    this.visitElement(subElement);
                }
                ++index;
            }
            for (Integer i : indexes) {
                this.visitAnyElement(elements, i);
            }
        }

        private void visitAnyElement(List<Element> elements, int index) {
            Element anyElement = elements.get(index);
            String ns = anyElement.attribute("namespace").getValue();
            ConfigurationPoint cp = this.cps.getConfigurationPointByNamespaceUri(ns);
            if (cp != null) {
                Element choiceElement = DocumentHelper.createElement((QName)XSD_CHOICE);
                String nsPrefix = SchemaUtil.getNamespacePrefix(cp.getPreferredNsPrefix(), ns);
                this.root.addNamespace(nsPrefix, ns);
                if (anyElement.attribute("minOccurs") != null) {
                    choiceElement.addAttribute("minOccurs", anyElement.attribute("minOccurs").getValue());
                }
                if (anyElement.attribute("maxOccurs") != null) {
                    choiceElement.addAttribute("maxOccurs", anyElement.attribute("maxOccurs").getValue());
                }
                for (Contribution contrib : cp.getContributions()) {
                    Element elementElement = DocumentHelper.createElement((QName)XSD_ELEMENT);
                    elementElement.addAttribute("ref", nsPrefix + ":" + contrib.getName());
                    choiceElement.add(elementElement);
                }
                if (cp.getDefaultElementName() != null) {
                    Element elementElement = DocumentHelper.createElement((QName)XSD_ELEMENT);
                    elementElement.addAttribute("ref", nsPrefix + ":" + cp.getDefaultElementName());
                    choiceElement.add(elementElement);
                }
                elements.set(index, choiceElement);
            }
        }
    }
}

