/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ResourceResolver;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.SourceInfo;
import com.alibaba.citrus.springext.impl.SchemaBase;
import com.alibaba.citrus.springext.support.ConfigurationPointSchemaSourceInfo;
import com.alibaba.citrus.springext.support.ConfigurationPointSourceInfo;
import com.alibaba.citrus.springext.support.ContributionSchemaSourceInfo;
import com.alibaba.citrus.springext.support.ContributionSourceInfo;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.springext.support.SourceInfoSupport;
import com.alibaba.citrus.springext.support.SpringPluggableSchemaSourceInfo;
import com.alibaba.citrus.springext.support.SpringSchemasSourceInfo;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.core.io.InputStreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaImpl<P extends SourceInfo<?>>
extends SchemaBase {
    private final String name;
    private final String version;
    private final String sourceDesc;
    private String targetNamespace;
    private String preferredNsPrefix;
    private String[] includes;
    private final Map<String, Schema.Element> elements;
    private final Collection<Schema.Element> elementCollection;
    private final boolean parsingTargetNamespace;
    private final SourceInfo<P> sourceInfo;

    public static Schema createForConfigurationPoint(String name, String version, String targetNamespace, String preferredNsPrefix, String sourceDesc, Document sourceDocument, SourceInfo<ConfigurationPointSourceInfo> sourceInfo) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ConfigurationPointSchemaImpl
        extends SchemaImpl<ConfigurationPointSourceInfo>
        implements ConfigurationPointSchemaSourceInfo {
            ConfigurationPointSchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source, Document sourceDocument, boolean isInputStreamSource, SourceInfo<ConfigurationPointSourceInfo> sourceInfo) {
                super(name, version, targetNamespace, preferredNsPrefix, parsingTargetNamespace, sourceDesc, source, sourceDocument, isInputStreamSource, sourceInfo);
            }
        }
        return new ConfigurationPointSchemaImpl(name, version, targetNamespace, preferredNsPrefix, false, sourceDesc, null, sourceDocument, false, sourceInfo);
    }

    public static Schema createForContribution(String name, String version, String sourceDesc, InputStreamSource source, SourceInfo<ContributionSourceInfo> sourceInfo, Schema.Transformer transformer) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ContributionSchemaImpl
        extends SchemaImpl<ContributionSourceInfo>
        implements ContributionSchemaSourceInfo {
            ContributionSchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source, Document sourceDocument, boolean isInputStreamSource, SourceInfo<ContributionSourceInfo> sourceInfo) {
                super(name, version, targetNamespace, preferredNsPrefix, parsingTargetNamespace, sourceDesc, source, sourceDocument, isInputStreamSource, sourceInfo);
            }
        }
        ContributionSchemaImpl schema = new ContributionSchemaImpl(name, version, null, null, false, sourceDesc, source, null, true, sourceInfo);
        if (transformer != null) {
            schema.transform(transformer);
        }
        return schema;
    }

    public static Schema createSpringPluggableSchema(String name, String version, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source, SourceInfo<SpringSchemasSourceInfo> sourceInfo, final Map<String, Map<String, String>> toolingParameters) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SpringPluggableSchemaImpl
        extends SchemaImpl<SpringSchemasSourceInfo>
        implements SpringPluggableSchemaSourceInfo {
            SpringPluggableSchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source, Document sourceDocument, boolean isInputStreamSource, SourceInfo<SpringSchemasSourceInfo> sourceInfo) {
                super(name, version, targetNamespace, preferredNsPrefix, parsingTargetNamespace, sourceDesc, source, sourceDocument, isInputStreamSource, sourceInfo);
            }

            @Override
            protected void doAnalyze() {
                Map params;
                String preferredNsPrefix;
                super.doAnalyze();
                String namespace = this.getTargetNamespace();
                if (toolingParameters != null && namespace != null && toolingParameters.containsKey(namespace) && (preferredNsPrefix = StringUtil.trimToNull((String)(params = (Map)toolingParameters.get(this.getTargetNamespace())).get("prefix"))) != null) {
                    this.setPreferredNsPrefix(preferredNsPrefix);
                }
            }
        }
        return new SpringPluggableSchemaImpl(name, version, null, null, parsingTargetNamespace, sourceDesc, source, null, true, sourceInfo);
    }

    public static Schema create(String name, String version, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source) {
        return new SchemaImpl(name, version, null, null, parsingTargetNamespace, sourceDesc, source, null, true, new SourceInfoSupport());
    }

    private SchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source, Document sourceDocument, boolean isInputStreamSource, SourceInfo<P> sourceInfo) {
        super(source, sourceDocument, isInputStreamSource);
        this.name = name;
        this.version = version;
        this.targetNamespace = StringUtil.trimToNull(targetNamespace);
        this.preferredNsPrefix = StringUtil.trimToNull(preferredNsPrefix);
        this.parsingTargetNamespace = parsingTargetNamespace;
        this.elements = CollectionUtil.createTreeMap();
        this.elementCollection = Collections.unmodifiableCollection(this.elements.values());
        this.sourceDesc = sourceDesc;
        this.sourceInfo = Assert.assertNotNull(sourceInfo, "sourceInfo", new Object[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getTargetNamespace() {
        if (this.parsingTargetNamespace) {
            this.analyze();
        }
        return this.targetNamespace;
    }

    @Override
    public String getPreferredNsPrefix() {
        return this.preferredNsPrefix;
    }

    protected void setPreferredNsPrefix(String preferredNsPrefix) {
        this.preferredNsPrefix = StringUtil.trimToNull(preferredNsPrefix);
    }

    @Override
    public String[] getIncludes() {
        this.analyze();
        return this.includes == null ? BasicConstant.EMPTY_STRING_ARRAY : this.includes;
    }

    @Override
    public Collection<Schema.Element> getElements() {
        this.analyze();
        return this.elementCollection;
    }

    @Override
    public Schema.Element getElement(String elementName) {
        if (elementName != null) {
            this.analyze();
            return this.elements.get(elementName);
        }
        return null;
    }

    @Override
    public void setElements(Collection<Schema.Element> elements) {
        this.elements.clear();
        if (elements != null) {
            for (Schema.Element element : elements) {
                this.elements.put(element.getName(), element);
            }
        }
    }

    @Override
    public String getNamespacePrefix() {
        return SchemaUtil.getNamespacePrefix(this.getPreferredNsPrefix(), this.getTargetNamespace());
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDesc;
    }

    @Override
    public String getText() {
        return this.getText(null, null);
    }

    @Override
    public String getText(String charset) {
        return this.getText(charset, null);
    }

    @Override
    public String getText(String charset, Schema.Transformer transformer) {
        String content;
        Document doc = this.getDocument();
        if (doc == null) {
            try {
                return StreamUtil.readText(this.getInputStream(), "ISO-8859-1", true);
            }
            catch (IOException e) {
                return null;
            }
        }
        if (transformer != null) {
            doc = (Document)doc.clone();
            transformer.transform(doc, this.getName());
        }
        try {
            content = SchemaUtil.getDocumentText(doc, charset);
        }
        catch (Exception e) {
            throw new ConfigurationPointException("Failed to read text of schema file: " + this.name + ", source=" + super.toString(), e);
        }
        return content;
    }

    @Override
    protected void doAnalyze() {
        Attribute attr;
        Document doc = this.getDocument();
        Element root = doc.getRootElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) || !"schema".equals(root.getName())) {
            return;
        }
        if (this.parsingTargetNamespace && (attr = root.attribute("targetNamespace")) != null) {
            this.targetNamespace = StringUtil.trimToNull(attr.getStringValue());
        }
        Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
        LinkedList<String> includeNames = CollectionUtil.createLinkedList();
        Iterator i = root.elementIterator(includeName);
        while (i.hasNext()) {
            Element includeElement = (Element)i.next();
            String schemaLocation = StringUtil.trimToNull(includeElement.attributeValue("schemaLocation"));
            if (schemaLocation == null) continue;
            includeNames.add(schemaLocation);
        }
        this.includes = includeNames.toArray(new String[includeNames.size()]);
        QName elementName = DocumentHelper.createQName((String)"element", (Namespace)xsd);
        Iterator i2 = root.elementIterator(elementName);
        while (i2.hasNext()) {
            ElementImpl element = new ElementImpl((Element)i2.next());
            if (element.getName() == null) continue;
            this.elements.put(element.getName(), element);
        }
    }

    public P getParent() {
        return this.sourceInfo.getParent();
    }

    public ResourceResolver.Resource getSource() {
        return this.sourceInfo.getSource();
    }

    public int getLineNumber() {
        return this.sourceInfo.getLineNumber();
    }

    @Override
    public String toString() {
        if (this.targetNamespace == null) {
            return String.format("Schema[name=%s, version=%s, source=%s]", this.name, this.version, super.toString());
        }
        return String.format("Schema[name=%s, version=%s, targetNamespace=%s, source=%s]", this.name, this.version, this.targetNamespace, super.toString());
    }

    private static class ElementImpl
    implements Schema.Element {
        private static final Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        private static final QName annotationName = DocumentHelper.createQName((String)"annotation", (Namespace)xsd);
        private static final QName documentationName = DocumentHelper.createQName((String)"documentation", (Namespace)xsd);
        private final String name;
        private final String annotation;

        private ElementImpl(Element elementElement) {
            String documentation;
            String name = StringUtil.trimToNull(elementElement.attributeValue("name"));
            Element annotationElement = elementElement.element(annotationName);
            Element documentationElement = annotationElement == null ? null : annotationElement.element(documentationName);
            String string = documentation = documentationElement == null ? null : documentationElement.getText();
            if (documentation != null) {
                documentation = StringUtil.trimToNull(documentation.replaceAll("[ \\t]*[\\r|\\n|\\r\\n][ \\t]*", "\n"));
            }
            this.name = name;
            this.annotation = documentation;
        }

        public String getName() {
            return this.name;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public String toString() {
            return "Element[" + this.name + "]";
        }
    }
}

