/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import javax.servlet.http.HttpServletRequest;

public abstract class WebAppURIBroker
extends URIBroker {
    protected static final int CONTEXT_PATH_INDEX = 0;
    protected boolean hasContextPath;

    protected void populateWithRequest(HttpServletRequest request) {
        super.populateWithRequest(request);
        if (!this.hasContextPath) {
            this.setContextPath(request.getContextPath());
        }
    }

    public String getContextPath() {
        if (this.hasContextPath) {
            return this.getPathSegmentAsString(0);
        }
        return null;
    }

    public WebAppURIBroker setContextPath(String contextPath) {
        this.setPathSegment(0, contextPath);
        this.hasContextPath = true;
        return this;
    }

    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof WebAppURIBroker) {
            WebAppURIBroker parentWebapp = (WebAppURIBroker)parent;
            if (!this.hasContextPath) {
                this.hasContextPath = parentWebapp.hasContextPath;
                this.setPathSegment(0, parentWebapp.getPathSegment(0));
            }
        }
    }

    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof WebAppURIBroker) {
            WebAppURIBroker parentWebapp = (WebAppURIBroker)parent;
            this.hasContextPath = parentWebapp.hasContextPath;
            this.setPathSegment(0, parentWebapp.getPathSegment(0));
        }
    }
}

