/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.service.uribroker.uri.WebAppURIBroker;
import com.alibaba.citrus.util.ServletUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletURIBroker
extends WebAppURIBroker {
    protected static final int SERVLET_PATH_INDEX = 1;
    protected static final int PATH_INFO_INDEX = 2;
    private boolean hasServletPath;

    @Override
    protected void populateWithRequest(HttpServletRequest request) {
        boolean savedHasContextPath = this.hasContextPath;
        super.populateWithRequest(request);
        if (!savedHasContextPath && !this.hasServletPath && ServletUtil.isPrefixServletMapping(request)) {
            this.setServletPath(request.getServletPath());
        }
    }

    public String getServletPath() {
        if (this.hasServletPath) {
            return this.getPathSegmentAsString(1);
        }
        return null;
    }

    public ServletURIBroker setServletPath(String servletPath) {
        this.setPathSegment(1, servletPath);
        this.hasServletPath = true;
        return this;
    }

    public String getScriptName() {
        if (this.hasContextPath) {
            return this.getContextPath() + this.getServletPath();
        }
        return this.getServletPath();
    }

    public String getPathInfo() {
        return this.getAllPathSegmentsAsString(2);
    }

    public List<String> getPathInfoElements() {
        return this.getAllPathSegments(2);
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof ServletURIBroker) {
            ServletURIBroker parentServlet = (ServletURIBroker)parent;
            if (!this.hasServletPath) {
                this.hasServletPath = parentServlet.hasServletPath;
                this.setPathSegment(1, parentServlet.getPathSegment(1));
            }
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof ServletURIBroker) {
            ServletURIBroker parentServlet = (ServletURIBroker)parent;
            this.hasServletPath = parentServlet.hasServletPath;
            this.setPathSegment(1, parentServlet.getPathSegment(1));
        }
    }
}

