/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.support;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractURIBrokerDefinitionParser<U extends URIBroker>
extends AbstractSingleBeanDefinitionParser<U>
implements ContributionAware {
    private ConfigurationPoint uriBrokerInterceptorsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.uriBrokerInterceptorsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/uris/interceptors", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        this.doParseAttributes(element, parserContext, builder);
        this.doParseElement(element, parserContext, builder);
    }

    protected void doParseAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, builder, "charset", "requestAware");
        builder.addPropertyValue("URIType", (Object)StringUtil.trimToNull(element.getAttribute("type")));
    }

    protected void doParseElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        DomUtil.ElementSelector simplePropertiesSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.or(DomUtil.name("serverURI"), DomUtil.name("serverScheme"), DomUtil.name("loginUser"), DomUtil.name("loginPassword"), DomUtil.name("serverName"), DomUtil.name("serverPort"), DomUtil.name("reference"), this.getSimplePropertiesSelector()));
        DomUtil.ElementSelector querySelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("query"));
        Map<Object, Object> queries = SpringExtUtil.createManagedMap(element, parserContext);
        List<Object> interceptors = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            String value;
            if (simplePropertiesSelector.accept(subElement)) {
                String name = subElement.getLocalName();
                value = ObjectUtil.defaultIfNull(subElement.getTextContent(), "");
                builder.addPropertyValue(name, (Object)value);
                continue;
            }
            if (querySelector.accept(subElement)) {
                String id = subElement.getAttribute("key");
                value = subElement.getTextContent();
                queries.put(id, value);
                continue;
            }
            BeanDefinitionHolder interceptor = SpringExtUtil.parseConfigurationPointBean(subElement, this.uriBrokerInterceptorsConfigurationPoint, parserContext, builder);
            if (interceptor == null) continue;
            interceptors.add(interceptor);
        }
        if (!queries.isEmpty()) {
            builder.addPropertyValue("query", queries);
        }
        if (!interceptors.isEmpty()) {
            builder.addPropertyValue("interceptors", interceptors);
        }
    }

    protected DomUtil.ElementSelector getSimplePropertiesSelector() {
        return DomUtil.none();
    }
}

