/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.support;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.support.ResourceAdapter;
import com.alibaba.citrus.springext.ResourceLoadingExtender;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class ResourceLoadingSupport
implements ResourceLoadingExtender,
ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoadingSupport.class);
    private final ApplicationContext factory;
    private final String resourceLoadingServiceName;
    private final ResourcePatternResolver resolver;
    private ResourceLoadingService resourceLoadingService;
    private boolean contextRefreshed = false;
    private boolean complained = false;

    public ResourceLoadingSupport(ApplicationContext factory) {
        this(factory, null);
    }

    public ResourceLoadingSupport(ApplicationContext factory, String resourceLoadingServiceName) {
        this.factory = Assert.assertNotNull(factory, "beanFactory", new Object[0]);
        this.resourceLoadingServiceName = ObjectUtil.defaultIfNull(StringUtil.trimToNull(resourceLoadingServiceName), "resourceLoadingService");
        this.resolver = new ResourceLoadingServicePatternResolver();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.contextRefreshed = true;
            this.resourceLoadingService = this.getResourceLoadingServiceFromContext();
        }
    }

    public ResourceLoadingService getResourceLoadingService() {
        if (this.contextRefreshed) {
            return this.resourceLoadingService;
        }
        return this.getResourceLoadingServiceFromContext();
    }

    private ResourceLoadingService getResourceLoadingServiceFromContext() {
        block6: {
            try {
                return (ResourceLoadingService)this.factory.getBean(this.resourceLoadingServiceName);
            }
            catch (IllegalStateException e) {
                ApplicationContext parent = this.factory.getParent();
                if (parent != null) {
                    try {
                        return (ResourceLoadingService)parent.getBean(this.resourceLoadingServiceName);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                if (this.complained) break block6;
                this.complained = true;
                log.warn("ResourceLoadingService does not exists: beanName={}", (Object)this.resourceLoadingServiceName);
            }
        }
        return null;
    }

    public org.springframework.core.io.Resource getResourceByPath(String path) {
        Resource resource;
        ResourceLoadingService resourceLoadingService = this.getResourceLoadingService();
        if (resourceLoadingService == null) {
            return null;
        }
        try {
            resource = resourceLoadingService.getResource(path, ResourceLoadingService.FOR_CREATE);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (ResourceNotFoundException e) {
            return new NonExistResource(path, e);
        }
        return new ResourceAdapter(path, resource, this);
    }

    public ResourcePatternResolver getResourcePatternResolver() {
        return this.resolver;
    }

    private static class NonExistResource
    extends AbstractResource
    implements ContextResource {
        private final String location;
        private final IOException ioe;
        private final String description;

        public NonExistResource(String location, ResourceNotFoundException e) {
            this.location = location;
            this.ioe = new IOException("Resource Not Found [" + location + "]");
            this.ioe.initCause(e);
            this.description = "NonExistResource[" + location + "]";
        }

        public String getPathWithinContext() {
            return this.location;
        }

        public String getDescription() {
            return this.description;
        }

        public URL getURL() throws IOException {
            throw (IOException)this.ioe.fillInStackTrace();
        }

        public File getFile() throws IOException {
            throw (IOException)this.ioe.fillInStackTrace();
        }

        public InputStream getInputStream() throws IOException {
            throw (IOException)this.ioe.fillInStackTrace();
        }

        public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
            throw (IOException)this.ioe.fillInStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceLoadingServicePatternResolver
    extends PathMatchingResourcePatternResolver {
        public ResourceLoadingServicePatternResolver() {
            super((ResourceLoader)ResourceLoadingSupport.this.factory);
        }

        protected Set<org.springframework.core.io.Resource> doFindPathMatchingFileResources(org.springframework.core.io.Resource rootDirResource, String subPattern) throws IOException {
            ResourceLoadingService resourceLoadingService = ResourceLoadingSupport.this.getResourceLoadingService();
            if (resourceLoadingService == null || !(rootDirResource instanceof ResourceAdapter)) {
                return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
            }
            ResourceAdapter rootResource = (ResourceAdapter)rootDirResource;
            String path = rootResource.getPathWithinContext();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String fullPattern = path + subPattern;
            LinkedHashSet<org.springframework.core.io.Resource> result = CollectionUtil.createLinkedHashSet();
            this.findMatchingResources(resourceLoadingService, fullPattern, path, result);
            return result;
        }

        private void findMatchingResources(ResourceLoadingService resourceLoadingService, String fullPattern, String dir, Set<org.springframework.core.io.Resource> result) throws IOException {
            String[] candidates;
            try {
                candidates = resourceLoadingService.list(dir);
            }
            catch (ResourceNotFoundException e) {
                return;
            }
            boolean dirDepthNotFixed = fullPattern.indexOf("**") != -1;
            for (String name : candidates) {
                String currPath = dir + name;
                if (currPath.endsWith("/") && (dirDepthNotFixed || StringUtils.countOccurrencesOf((String)currPath, (String)"/") <= StringUtils.countOccurrencesOf((String)fullPattern, (String)"/"))) {
                    this.findMatchingResources(resourceLoadingService, fullPattern, currPath, result);
                }
                if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
                try {
                    result.add((org.springframework.core.io.Resource)new ResourceAdapter(currPath, resourceLoadingService.getResource(currPath)));
                }
                catch (ResourceNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }
}

