/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceMatchResult;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.impl.ResourceAlias;
import com.alibaba.citrus.service.resource.impl.ResourceLoaderMapping;
import com.alibaba.citrus.service.resource.impl.ResourceMapping;
import com.alibaba.citrus.service.resource.impl.ResourcePattern;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResourceLoadingContext<R>
implements ResourceMatchResult {
    private static final Set<ResourceLoadingOption> EMPTY_OPTIONS = Collections.emptySet();
    protected final Logger log;
    protected final ResourceLoadingService parent;
    private final String originalResourceName;
    private final Set<ResourceLoadingOption> originalOptions;
    private final ResourceMapping[] mappings;
    private final BestResourcesMatcher resourcesMatcher;
    private List<ResourceMapping> visitedMappings;
    protected String resourceName;
    protected Set<ResourceLoadingOption> options;
    protected ResourcePattern lastMatchedPattern;
    protected MatchResultSubstitution lastSubstitution;
    private LinkedList<SavedMatchResult> savedMatchResultStack = CollectionUtil.createLinkedList();

    public AbstractResourceLoadingContext(String resourceName, Set<ResourceLoadingOption> options, ResourceMapping[] mappings, ResourceLoadingService parent, Logger log) {
        this.log = Assert.assertNotNull(log, "logger", new Object[0]);
        this.parent = parent;
        this.originalResourceName = FileUtil.normalizeAbsolutePath(Assert.assertNotNull(StringUtil.trimToNull(resourceName), "resourceName", new Object[0]));
        this.originalOptions = ObjectUtil.defaultIfNull(options, EMPTY_OPTIONS);
        this.mappings = Assert.assertNotNull(mappings, "mappings", new Object[0]);
        this.resourcesMatcher = new BestResourcesMatcher();
        this.resourceName = this.originalResourceName;
        this.options = this.originalOptions;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String substitute(String substitution) {
        return this.resourceName.substring(0, this.lastSubstitution.getMatch().start()) + this.lastSubstitution.substitute(substitution) + this.resourceName.substring(this.lastSubstitution.getMatch().end());
    }

    @Override
    public void saveLastResult() {
        SavedMatchResult savedMatchResult = new SavedMatchResult();
        savedMatchResult.resourceName = this.resourceName;
        savedMatchResult.lastMatchedPattern = this.lastMatchedPattern;
        savedMatchResult.lastSubstitution = this.lastSubstitution;
        savedMatchResult.visitedMappings = this.visitedMappings.toArray(new ResourceMapping[this.visitedMappings.size()]);
        this.savedMatchResultStack.push(savedMatchResult);
    }

    @Override
    public void restoreLastResult() {
        SavedMatchResult savedMatchResult = this.savedMatchResultStack.pop();
        this.resourceName = savedMatchResult.resourceName;
        this.lastMatchedPattern = savedMatchResult.lastMatchedPattern;
        this.lastSubstitution = savedMatchResult.lastSubstitution;
        this.visitedMappings.clear();
        for (ResourceMapping mapping : savedMatchResult.visitedMappings) {
            this.visitedMappings.add(mapping);
        }
    }

    protected R doLoad(String newResourceName, Set<ResourceLoadingOption> newOptions) throws ResourceNotFoundException {
        this.resourceName = newResourceName;
        this.options = newOptions;
        this.log.trace("Looking for resource: name={}", (Object)this.resourceName);
        R resource = null;
        ResourceNotFoundException chainingException = null;
        if (this.visitedMappings == null) {
            this.visitedMappings = CollectionUtil.createLinkedList();
        }
        if (this.findBestMatch()) {
            if (this.lastMatchedPattern instanceof ResourceAlias) {
                if (this.parent != null) {
                    this.log.trace("Resource \"{}\" not found.  Trying to find it in super ResourceLoadingService", (Object)this.resourceName);
                    try {
                        resource = this.loadParentResource(this.resourceName, this.options);
                    }
                    catch (ResourceNotFoundException e) {
                        chainingException = e;
                    }
                }
            } else {
                ResourceLoaderMapping mapping = (ResourceLoaderMapping)this.lastMatchedPattern;
                resource = this.loadMappedResource(mapping, this.options);
                if (resource == null && !ObjectUtil.isEquals(this.resourceName, this.originalResourceName)) {
                    this.logResourceNotFound(this.resourceName);
                    chainingException = new ResourceNotFoundException(String.format("Could not find resource \"%s\"", this.resourceName));
                }
            }
        } else if (this.parent != null) {
            this.log.trace("Resource \"{}\" not found.  Trying to find it in super ResourceLoadingService", (Object)this.resourceName);
            resource = this.loadParentResource(this.resourceName, this.options);
        }
        if (resource == null) {
            this.logResourceNotFound(this.originalResourceName);
            throw new ResourceNotFoundException(String.format("Could not find resource \"%s\"", this.originalResourceName), chainingException);
        }
        this.log.debug("Found resource \"{}\": {}", (Object)this.originalResourceName, resource);
        return resource;
    }

    private boolean findBestMatch() throws ResourceNotFoundException {
        if (this.resourcesMatcher.matches(this.resourceName)) {
            ResourceMapping resourceMapping = (ResourceMapping)this.resourcesMatcher.bestMatchPettern;
            this.lastMatchedPattern = resourceMapping;
            this.lastSubstitution = new MatchResultSubstitution(this.resourcesMatcher.bestMatchResult);
            if (resourceMapping instanceof ResourceAlias) {
                ResourceAlias alias = (ResourceAlias)resourceMapping;
                String newResourceName = this.substitute(alias.getName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Resource \"{}\" matched resource-alias pattern: \"{}\".  Use a new resourceName: \"{}\"", new Object[]{this.resourceName, alias.getPatternName(), newResourceName});
                }
                this.visitMapping(alias);
                this.visitedMappings.add(alias);
                this.resourceName = newResourceName;
                this.findBestMatch();
            } else if (resourceMapping instanceof ResourceLoaderMapping) {
                ResourceLoaderMapping mapping = (ResourceLoaderMapping)resourceMapping;
                this.log.debug("Resource \"{}\" matched pattern: \"{}\"", (Object)this.resourceName, (Object)mapping.getPatternName());
                this.visitMapping(mapping);
                this.visitedMappings.add(mapping);
            }
            return true;
        }
        return false;
    }

    protected abstract void visitMapping(ResourceMapping var1);

    protected abstract R loadParentResource(String var1, Set<ResourceLoadingOption> var2) throws ResourceNotFoundException;

    protected abstract R loadMappedResource(ResourceLoaderMapping var1, Set<ResourceLoadingOption> var2);

    protected final R loadContextResource(String newResourceName, Set<ResourceLoadingOption> newOptions) {
        Assert.assertTrue(!this.visitedMappings.isEmpty(), Assert.ExceptionType.ILLEGAL_STATE, "getResource() can only be called within a ResourceLoader", new Object[0]);
        try {
            if (this.resourceName.equals(newResourceName)) {
                if (this.parent == null) {
                    this.log.debug("No parent ResourceLoadingService exists for loading resource \"{}\"", (Object)newResourceName);
                    return null;
                }
                return this.loadParentResource(newResourceName, newOptions);
            }
            this.log.trace("Trying to find resource \"{}\" using a new resourceName: \"{}\"", (Object)this.resourceName, (Object)newResourceName);
            return this.doLoad(newResourceName, newOptions);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    private void logResourceNotFound(String resourceName) {
        this.log.trace("Resource \"{}\" not found", (Object)resourceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BestResourcesMatcher
    extends BestMatcher<ResourceMapping> {
        private int i;

        private BestResourcesMatcher() {
        }

        @Override
        protected void init() {
            this.i = 0;
            Assert.assertNotNull(AbstractResourceLoadingContext.this.visitedMappings, "visitedMappings", new Object[0]);
        }

        @Override
        protected ResourceMapping nextPattern() {
            if (this.i < AbstractResourceLoadingContext.this.mappings.length) {
                return AbstractResourceLoadingContext.this.mappings[this.i++];
            }
            return null;
        }

        @Override
        protected boolean accept(ResourceMapping pattern) {
            if (AbstractResourceLoadingContext.this.visitedMappings.isEmpty() && pattern.isInternal()) {
                return false;
            }
            return !AbstractResourceLoadingContext.this.visitedMappings.contains(pattern);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class BestMatcher<P extends ResourcePattern> {
        protected String resourceName;
        protected P bestMatchPettern;
        protected MatchResult bestMatchResult;
        private int bestMatchRelevancy;
        private int bestMatchLength;

        protected BestMatcher() {
        }

        protected abstract void init();

        protected abstract boolean accept(P var1);

        protected abstract P nextPattern();

        public final boolean matches(String resourceName) {
            this.resourceName = Assert.assertNotNull(resourceName, "resourceName", new Object[0]);
            this.bestMatchPettern = null;
            this.bestMatchResult = null;
            this.bestMatchRelevancy = -1;
            this.bestMatchLength = -1;
            this.init();
            P pattern = this.nextPattern();
            while (pattern != null) {
                Matcher matcher = ((ResourcePattern)pattern).getPattern().matcher(resourceName);
                if (matcher.find() && this.accept(pattern)) {
                    int relevancy = ((ResourcePattern)pattern).getRelevancy();
                    int length = matcher.group().length();
                    if (relevancy > this.bestMatchRelevancy || relevancy == this.bestMatchRelevancy && length > this.bestMatchLength) {
                        this.bestMatchPettern = pattern;
                        this.bestMatchResult = matcher;
                        this.bestMatchRelevancy = relevancy;
                        this.bestMatchLength = length;
                    }
                }
                pattern = this.nextPattern();
            }
            return this.bestMatchLength >= 0;
        }
    }

    private static class SavedMatchResult {
        String resourceName;
        ResourcePattern lastMatchedPattern;
        MatchResultSubstitution lastSubstitution;
        ResourceMapping[] visitedMappings;

        private SavedMatchResult() {
        }
    }
}

