/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.valueencoder.impl;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.requestcontext.session.valueencoder.AbstractSessionValueEncoder;
import com.alibaba.citrus.service.requestcontext.util.QueryStringParser;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedValuesEncoder
extends AbstractSessionValueEncoder {
    private Class<?> valueType;

    public void setValueType(Class<?> type) {
        this.valueType = type;
    }

    @Override
    protected boolean doURLEncode() {
        return false;
    }

    @Override
    protected boolean doCompress() {
        return true;
    }

    protected String getEqualSign() {
        return ":";
    }

    @Override
    protected String encodeValue(Object value) throws Exception {
        Assert.assertTrue(value instanceof Map, "wrong session attribute type: " + value.getClass(), new Object[0]);
        Map map = (Map)value;
        LinkedHashMap<String, String> encodedMap = CollectionUtil.createLinkedHashMap();
        TypeConverter converter = this.getTypeConverter();
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String encodedValue = this.convertToString(this.valueType, entry.getValue(), converter);
            encodedMap.put(key, encodedValue);
        }
        return new QueryStringParser(this.getCharset()).setEqualSign(this.getEqualSign()).append(encodedMap).toQueryString();
    }

    @Override
    protected Object decodeValue(String encodedValue) throws Exception {
        final LinkedHashMap map = CollectionUtil.createLinkedHashMap();
        final TypeConverter converter = this.getTypeConverter();
        new QueryStringParser(this.getCharset()){

            protected void add(String key, String encodedValue) {
                map.put(key, MappedValuesEncoder.this.convertToType(MappedValuesEncoder.this.valueType, encodedValue, converter));
            }
        }.setEqualSign(this.getEqualSign()).parse(encodedValue);
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<MappedValuesEncoder>
    implements ContributionAware {
        private ConfigurationPoint encrypterConfigurationPoint;

        @Override
        public void setContribution(Contribution contrib) {
            this.encrypterConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/encrypters", contrib);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "valueType", "charset");
            builder.addPropertyValue("propertyEditorRegistrars", PropertyEditorRegistrarsSupport.parseRegistrars(element, parserContext, builder));
            for (Element subElement : DomUtil.subElements(element)) {
                BeanDefinitionHolder encrypter = SpringExtUtil.parseConfigurationPointBean(subElement, this.encrypterConfigurationPoint, parserContext, builder);
                if (encrypter == null) continue;
                builder.addPropertyValue("encrypter", (Object)encrypter);
                break;
            }
        }
    }
}

