/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rundata.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.buffered.BufferedRequestContext;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitRequestContext;
import com.alibaba.citrus.service.requestcontext.locale.SetLocaleRequestContext;
import com.alibaba.citrus.service.requestcontext.parser.CookieParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.rundata.RunData;
import com.alibaba.citrus.service.requestcontext.rundata.User;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.ByteArray;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunDataImpl
extends AbstractRequestContextWrapper
implements RunData {
    private static final Logger log = LoggerFactory.getLogger(RunData.class);
    private final BufferedRequestContext bufferedRequestContext;
    private final LazyCommitRequestContext lazyCommitRequestContext;
    private final SetLocaleRequestContext setLocaleRequestContext;
    private final ParserRequestContext parserRequestContext;
    private User user;

    public RunDataImpl(RequestContext wrappedContext) {
        super(wrappedContext);
        this.bufferedRequestContext = RequestContextUtil.findRequestContext(wrappedContext, BufferedRequestContext.class);
        this.lazyCommitRequestContext = RequestContextUtil.findRequestContext(wrappedContext, LazyCommitRequestContext.class);
        this.setLocaleRequestContext = RequestContextUtil.findRequestContext(wrappedContext, SetLocaleRequestContext.class);
        this.parserRequestContext = RequestContextUtil.findRequestContext(wrappedContext, ParserRequestContext.class);
        if (this.bufferedRequestContext == null) {
            log.debug("RunData feature BufferedRequestContext disabled");
        }
        if (this.lazyCommitRequestContext == null) {
            log.debug("RunData feature LazyCommitRequestContext disabled");
        }
        if (this.setLocaleRequestContext == null) {
            log.debug("RunData feature SetLocaleRequestContext disabled");
        }
        if (this.parserRequestContext == null) {
            log.debug("RunData feature ParserRequestContext disabled");
        }
    }

    protected BufferedRequestContext getBufferedRequestContext() {
        return Assert.assertNotNull(this.bufferedRequestContext, "Could not find BufferedRequestContext in request context chain", new Object[0]);
    }

    protected LazyCommitRequestContext getLazyCommitRequestContext() {
        return Assert.assertNotNull(this.lazyCommitRequestContext, "Could not find LazyCommitRequestContext in request context chain", new Object[0]);
    }

    protected SetLocaleRequestContext getSetLocaleRequestContext() {
        return Assert.assertNotNull(this.setLocaleRequestContext, "Could not find SetLocaleRequestContext in request context chain", new Object[0]);
    }

    protected ParserRequestContext getParserRequestContext() {
        return Assert.assertNotNull(this.parserRequestContext, "Could not find ParserRequestContext in request context chain", new Object[0]);
    }

    public ParameterParser getParameters() {
        return this.getParserRequestContext().getParameters();
    }

    public CookieParser getCookies() {
        return this.getParserRequestContext().getCookies();
    }

    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getServletPath() {
        return this.getRequest().getServletPath();
    }

    public String getPathInfo() {
        return this.getRequest().getPathInfo();
    }

    public String getRequestURL() {
        return this.getRequestURL(true);
    }

    public String getRequestURL(boolean withQueryString) {
        String queryString;
        StringBuffer buffer = this.getRequest().getRequestURL();
        if (withQueryString && (queryString = StringUtil.trimToNull(this.getRequest().getQueryString())) != null) {
            buffer.append('?').append(queryString);
        }
        return buffer.toString();
    }

    public boolean isPostRequest() {
        return "post".equalsIgnoreCase(this.getRequest().getMethod());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Object getAttribute(String key) {
        return this.getRequest().getAttribute(key);
    }

    public void setAttribute(String key, Object object) {
        if (object == null) {
            this.getRequest().removeAttribute(key);
        } else {
            this.getRequest().setAttribute(key, object);
        }
    }

    public String getContentType() {
        return this.getSetLocaleRequestContext().getResponseContentType();
    }

    public void setContentType(String contentType) {
        this.getResponse().setContentType(contentType);
    }

    public void setContentType(String contentType, boolean appendCharset) {
        this.getSetLocaleRequestContext().setResponseContentType(contentType, appendCharset);
    }

    public String getCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        this.getSetLocaleRequestContext().setResponseCharacterEncoding(charset);
    }

    public String getRedirectLocation() {
        return this.getLazyCommitRequestContext().getRedirectLocation();
    }

    public void setRedirectLocation(String location) throws IOException {
        this.getResponse().sendRedirect(location);
    }

    public boolean isRedirected() {
        return this.getLazyCommitRequestContext().isRedirected();
    }

    public int getStatusCode() {
        return this.getLazyCommitRequestContext().getStatus();
    }

    public void setStatusCode(int status) {
        this.getResponse().setStatus(status);
    }

    public boolean isBuffering() {
        return this.getBufferedRequestContext().isBuffering();
    }

    public void setBuffering(boolean buffering) {
        this.getBufferedRequestContext().setBuffering(buffering);
    }

    public void pushBuffer() {
        this.getBufferedRequestContext().pushBuffer();
    }

    public ByteArray popByteBuffer() {
        return this.getBufferedRequestContext().popByteBuffer();
    }

    public String popCharBuffer() {
        return this.getBufferedRequestContext().popCharBuffer();
    }

    public void resetBuffer() {
        this.getResponse().resetBuffer();
    }

    public String convertCase(String str) {
        return this.getParserRequestContext().convertCase(str);
    }
}

