/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.Flags;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.regex.MatchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class RewriteSubstitution
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RewriteSubstitution.class);
    private String uri;
    private SubstitutionFlags flags;
    private Parameter[] parameters;

    public void setUri(String uri) {
        this.uri = StringUtil.trimToNull(uri);
    }

    public SubstitutionFlags getFlags() {
        return this.flags;
    }

    public void setFlags(String[] flags) {
        this.flags = new SubstitutionFlags(flags);
    }

    public void setParameters(Parameter[] params) {
        this.parameters = params;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.flags == null) {
            this.flags = new SubstitutionFlags();
        }
        if (this.parameters == null) {
            this.parameters = new Parameter[0];
        }
    }

    public String substitute(String path, MatchResultSubstitution resultSubs) {
        if (this.uri == null) {
            if (log.isTraceEnabled()) {
                log.trace("No substitution applied to path: \"{}\"", (Object)StringEscapeUtil.escapeJava(path));
            }
            return path;
        }
        String subsPath = resultSubs.substitute(this.uri);
        if (!RewriteUtil.isFullURL(subsPath)) {
            MatchResult ruleMatchResult = resultSubs.getMatch();
            subsPath = path.substring(0, ruleMatchResult.start()) + subsPath + path.substring(ruleMatchResult.end());
        }
        if (log.isDebugEnabled()) {
            log.debug("Rewriting \"{}\" to \"{}\"", (Object)StringEscapeUtil.escapeJava(path), (Object)StringEscapeUtil.escapeJava(subsPath));
        }
        return subsPath;
    }

    public boolean substituteParameters(ParameterParser params, MatchResultSubstitution resultSubs) {
        boolean parameterSubstituted = false;
        if (!params.isEmpty() && !this.flags.hasQSA()) {
            params.clear();
            parameterSubstituted = true;
            log.debug("All parameters have been cleared.  To prevent from clearing the parameters, just specify \"QSA\" or \"qsappend\"(query string append) flag to the substitution");
        }
        for (Parameter param : this.parameters) {
            String key = param.getKey(resultSubs);
            String[] values = param.getValues(resultSubs);
            if (StringUtil.isEmpty(key)) continue;
            if (ArrayUtil.isEmptyArray(values) || values.length == 1 && StringUtil.isEmpty(values[0])) {
                params.remove(key);
                if (log.isDebugEnabled()) {
                    log.debug("Removed parameter: \"{}\"", (Object)StringEscapeUtil.escapeJava(key));
                }
            } else {
                params.setStrings(key, values);
                if (log.isDebugEnabled()) {
                    log.debug("Set parameter: \"{}\"=\"{}\"", (Object)StringEscapeUtil.escapeJava(key), (Object)ObjectUtil.toString(values));
                }
            }
            parameterSubstituted = true;
        }
        return parameterSubstituted;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        if (this.uri != null) {
            mb.append("uri", this.uri);
        }
        if (!ArrayUtil.isEmptyArray(this.parameters)) {
            mb.append("params", this.parameters);
        }
        if (!this.flags.isEmpty()) {
            mb.append("flags", this.flags);
        }
        return new ToStringBuilder().append("Substitution").append(mb).toString();
    }

    public static class Parameter
    implements InitializingBean {
        private String key;
        private String[] values;

        public void setKey(String key) {
            this.key = StringUtil.trimToNull(key);
        }

        public void setValue(String value) {
            this.values = new String[]{value};
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public void afterPropertiesSet() throws Exception {
            Assert.assertNotNull(this.key, "missing key attribute for parameter", new Object[0]);
            if (this.values == null) {
                this.values = BasicConstant.EMPTY_STRING_ARRAY;
            }
        }

        public String getKey(MatchResultSubstitution resultSubs) {
            return resultSubs.substitute(this.key);
        }

        public String[] getValues(MatchResultSubstitution resultSubs) {
            String[] subsValues = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                subsValues[i] = resultSubs.substitute(this.values[i]);
            }
            return subsValues;
        }

        public String toString() {
            ToStringBuilder buf = new ToStringBuilder().append(this.key).append(" = ");
            if (this.values.length == 1) {
                buf.append(this.values[0]);
            } else {
                buf.appendArray(this.values);
            }
            return buf.toString();
        }
    }

    public static class SubstitutionFlags
    extends Flags {
        public SubstitutionFlags() {
        }

        public SubstitutionFlags(String ... flags) {
            super(flags);
        }

        public boolean hasQSA() {
            return this.hasFlags("QSA", "qsappend");
        }

        public boolean hasC() {
            return this.hasFlags("C", "chain");
        }

        public boolean hasL() {
            return this.hasFlags("L", "last");
        }

        public int getRedirectCode() {
            String value = this.getFlagValue("R", "redirect");
            int defaultStatusCode = 302;
            if (value == null) {
                return 0;
            }
            if (value.length() == 0) {
                return defaultStatusCode;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultStatusCode;
            }
        }
    }
}

