/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.moduleloader.Module;
import com.alibaba.citrus.service.moduleloader.ModuleAdapterFactory;
import com.alibaba.citrus.service.moduleloader.ModuleFactory;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderService;
import com.alibaba.citrus.service.moduleloader.ModuleNotFoundException;
import com.alibaba.citrus.service.moduleloader.UnadaptableModuleException;
import com.alibaba.citrus.service.moduleloader.impl.ModuleKey;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLoaderServiceImpl
extends AbstractService<ModuleLoaderService>
implements ModuleLoaderService,
ProductionModeAware {
    private Map<ModuleKey, Module> moduleCache = CollectionUtil.createConcurrentHashMap();
    private boolean productionMode = true;
    private Boolean cacheEnabled;
    private ModuleFactory[] factories;
    private ModuleAdapterFactory[] adapters;

    public void setFactories(ModuleFactory[] factories) {
        this.factories = factories;
    }

    public void setAdapters(ModuleAdapterFactory[] adapters) {
        this.adapters = adapters;
    }

    public Boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
    }

    @Override
    protected void init() {
        Assert.assertNotNull(this.factories, "factories", new Object[0]);
        Assert.assertNotNull(this.adapters, "adapters", new Object[0]);
        if (this.cacheEnabled == null) {
            this.cacheEnabled = this.productionMode;
        }
        this.getLogger().debug("Initialized {}", (Object)this);
    }

    @Override
    public Set<String> getModuleTypes() {
        TreeSet<String> types = CollectionUtil.createTreeSet();
        for (ModuleFactory factory : this.factories) {
            types.addAll(factory.getModuleTypes());
        }
        return types;
    }

    @Override
    public Set<String> getModuleNames(String moduleType) {
        TreeSet<String> names = CollectionUtil.createTreeSet();
        for (ModuleFactory factory : this.factories) {
            names.addAll(factory.getModuleNames(moduleType));
        }
        return names;
    }

    @Override
    public Module getModule(String moduleType, String moduleName) throws ModuleLoaderException, ModuleNotFoundException {
        Module module = this.getModuleQuiet(moduleType, moduleName);
        if (module == null) {
            throw new ModuleNotFoundException("Module not found: type=" + moduleType + ", name=" + moduleName);
        }
        return module;
    }

    @Override
    public Module getModuleQuiet(String moduleType, String moduleName) throws ModuleLoaderException {
        ModuleFactory factory;
        int i$;
        Module module;
        ModuleKey moduleKey = new ModuleKey(moduleType, moduleName);
        moduleType = moduleKey.getModuleType();
        moduleName = moduleKey.getModuleName();
        if (this.cacheEnabled.booleanValue() && (module = this.moduleCache.get(moduleKey)) != null) {
            return module;
        }
        Object moduleObject = null;
        Module module2 = null;
        Object[] arr$ = this.factories;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$ && (moduleObject = (factory = arr$[i$]).getModule(moduleType, moduleName)) == null; ++i$) {
        }
        if (moduleObject != null) {
            if (moduleObject instanceof Module) {
                module2 = (Module)moduleObject;
            } else {
                Object adapter;
                arr$ = this.adapters;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$ && (module2 = (adapter = arr$[i$]).adapt(moduleType, moduleName, moduleObject)) == null; ++i$) {
                }
            }
        }
        if (module2 == null && moduleObject != null) {
            throw new UnadaptableModuleException("Could not adapt object to module: type=" + moduleType + ", name=" + moduleName + ", class=" + moduleObject.getClass());
        }
        if (this.cacheEnabled.booleanValue() && module2 != null) {
            this.moduleCache.put(moduleKey, module2);
        }
        return module2;
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("factories", this.factories);
        mb.append("adapters", this.adapters);
        return new ToStringBuilder().append(this.getBeanDescription()).append(mb).toString();
    }
}

