/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.form.CustomErrorNotFoundException;
import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Group;
import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.impl.FormParameters;
import com.alibaba.citrus.service.form.impl.GroupImpl;
import com.alibaba.citrus.service.form.impl.MessageContextFactory;
import com.alibaba.citrus.service.form.impl.ValidatorContextImpl;
import com.alibaba.citrus.service.requestcontext.support.ValueListSupport;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.ByteArrayInputStream;
import com.alibaba.citrus.util.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldImpl
extends ValueListSupport
implements Field {
    private static final Logger log = LoggerFactory.getLogger(Field.class);
    private final FieldConfig fieldConfig;
    private final Group group;
    private final String fieldKey;
    private final MessageContext messageContext;
    private boolean valid;
    private String message;
    private Attachment attachment;

    public FieldImpl(FieldConfig fieldConfig, Group group) {
        super(Assert.assertNotNull(group, "group", new Object[0]).getForm().getTypeConverter(), fieldConfig.getGroupConfig().getFormConfig().isConverterQuiet());
        this.fieldConfig = Assert.assertNotNull(fieldConfig, "fieldConfig", new Object[0]);
        this.group = group;
        this.fieldKey = group.getKey() + "." + fieldConfig.getKey();
        this.messageContext = MessageContextFactory.newInstance(this);
    }

    @Override
    public FieldConfig getFieldConfig() {
        return this.fieldConfig;
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getKey() {
        return this.fieldKey;
    }

    @Override
    public String getAbsentKey() {
        return this.getKey() + ".absent";
    }

    @Override
    public String getAttachmentKey() {
        return this.getKey() + ".attach";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String id) {
        this.setMessage(id, null);
    }

    @Override
    public void setMessage(String id, Map<String, ?> params) {
        if (this.isValid()) {
            boolean found = false;
            for (Validator validator : this.getFieldConfig().getValidators()) {
                if (!ObjectUtil.isEquals(validator.getId(), id)) continue;
                MessageContext expressionContext = MessageContextFactory.newInstance(this, validator);
                expressionContext.putAll(params);
                this.valid = false;
                found = true;
                this.message = validator.getMessage(new ValidatorContextImpl(expressionContext, this));
                if (this.message != null) break;
                throw new CustomErrorNotFoundException("No message specified for error ID \"" + id + "\" in " + this);
            }
            if (found) {
                ((GroupImpl)this.getGroup()).setValid(this.valid);
            } else {
                throw new CustomErrorNotFoundException("Specified error ID \"" + id + "\" was not found in " + this);
            }
        }
    }

    public void init(FormParameters request) {
        this.valid = true;
        this.attachment = null;
        if (request == null) {
            this.setValues(this.getFieldConfig().getDefaultValues());
        } else {
            String attachmentEncoded;
            this.setValues(request.getValues(this.getKey()));
            if (this.size() == 0) {
                this.setValues(request.getValues(this.getAbsentKey()));
            }
            if ((attachmentEncoded = StringUtil.trimToNull(request.getStringValue(this.getAttachmentKey()))) != null) {
                this.attachment = new Attachment(attachmentEncoded);
            }
        }
    }

    protected void validate() {
        this.valid = true;
        for (Validator validator : this.getFieldConfig().getValidators()) {
            MessageContext expressionContext;
            ValidatorContextImpl context;
            boolean passed = validator.validate(context = new ValidatorContextImpl(expressionContext = MessageContextFactory.newInstance(this, validator), this));
            if (passed) continue;
            this.valid = false;
            this.message = validator.getMessage(context);
            break;
        }
        ((GroupImpl)this.getGroup()).setValid(this.valid);
    }

    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public String getName() {
        return this.getFieldConfig().getName();
    }

    @Override
    public String getStringValue() {
        return this.getStringValue("");
    }

    @Override
    public String getDisplayName() {
        return this.getFieldConfig().getDisplayName();
    }

    @Override
    public String getDefaultValue() {
        return this.getFieldConfig().getDefaultValue();
    }

    @Override
    public String[] getDefaultValues() {
        return this.getFieldConfig().getDefaultValues();
    }

    @Override
    public void addValue(Object value) {
        if (this.getFieldConfig().isTrimming() && value instanceof String) {
            value = StringUtil.trimToNull((String)value);
        }
        super.addValue(value);
    }

    @Override
    public Object getAttachment() {
        return this.attachment == null ? null : this.attachment.getAttachment();
    }

    @Override
    public String getAttachmentEncoded() {
        return this.attachment == null ? null : this.attachment.getAttachmentEncoded();
    }

    @Override
    public boolean hasAttachment() {
        return this.attachment != null && this.attachment.getAttachment() != null;
    }

    @Override
    public void setAttachment(Object attachment) {
        if (this.attachment == null) {
            this.attachment = new Attachment(attachment);
        }
    }

    @Override
    public void clearAttachment() {
        this.attachment = null;
    }

    @Override
    public String toString() {
        return "Field[group: " + this.getGroup().getGroupConfig().getName() + "." + this.getGroup().getInstanceKey() + ", name: " + this.getFieldConfig().getName() + ", values: " + ObjectUtil.toString(this.getValues()) + ", valid: " + this.isValid() + "]";
    }

    private static class Attachment {
        private Object attachment;
        private String attachmentEncoded;

        public Attachment(Object attachment) {
            this.setAttachment(attachment);
        }

        public Attachment(String attachmentEncoded) {
            this.setAttachment(this.decode(attachmentEncoded));
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public void setAttachment(Object attachment) {
            this.attachment = attachment;
            this.attachmentEncoded = null;
        }

        public String getAttachmentEncoded() {
            if (this.attachment != null && this.attachmentEncoded == null) {
                this.attachmentEncoded = this.encode(this.attachment);
            }
            return this.attachmentEncoded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String encode(Object attachment) {
            if (attachment == null) {
                return null;
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Deflater def = new Deflater(9, false);
                DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, def);
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(dos);
                    oos.writeObject(attachment);
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException e) {}
                    }
                    def.end();
                }
                byte[] plaintext = baos.toByteArray().toByteArray();
                return StringEscapeUtil.escapeURL(new String(Base64.encodeBase64((byte[])plaintext, (boolean)false), "ISO-8859-1"));
            }
            catch (Exception e) {
                log.error("Failed to encode field attachment", (Throwable)e);
                return "!Failure: " + e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object decode(String attachmentEncoded) {
            if (attachmentEncoded == null || attachmentEncoded.startsWith("!Failure:")) {
                return null;
            }
            byte[] plaintext = null;
            try {
                String encoded = StringEscapeUtil.unescapeURL(attachmentEncoded);
                plaintext = Base64.decodeBase64((byte[])encoded.getBytes("ISO-8859-1"));
                if (ArrayUtil.isEmptyArray(plaintext)) {
                    log.warn("Field attachment content is empty: " + encoded);
                    return null;
                }
            }
            catch (Exception e) {
                log.warn("Failed to decode field attachment: " + e);
                return null;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(plaintext);
            Inflater inf = new Inflater(false);
            InflaterInputStream iis = new InflaterInputStream(bais, inf);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(iis);
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                log.warn("Failed to parse field attachment", (Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {}
                }
                inf.end();
            }
            return null;
        }
    }
}

