/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.configuration.support;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer
implements ResourceLoaderAware,
InitializingBean {
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private ResourceLoader loader;
    private String locationNames;

    public PropertyPlaceholderConfigurer() {
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void setLocationNames(String locations) {
        this.locationNames = locations;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull(this.loader, "no resourceLoader", new Object[0]);
        if (this.locationNames != null) {
            this.locationNames = this.resolveSystemPropertyPlaceholders(this.locationNames);
        }
        if (StringUtils.hasLength((String)this.locationNames)) {
            String[] locations = StringUtils.commaDelimitedListToStringArray((String)this.locationNames);
            ArrayList<Resource> resources = CollectionUtil.createArrayList(locations.length);
            for (String location : locations) {
                if ((location = StringUtil.trimToNull(location)) == null) continue;
                resources.add(this.loader.getResource(location));
            }
            super.setLocations(resources.toArray(new Resource[resources.size()]));
        }
    }

    private String resolveSystemPropertyPlaceholders(String text) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex >= 0) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String value = this.resolveSystemPropertyPlaceholder(placeholder);
                    if (value != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), value);
                        nextIndex = startIndex + value.length();
                    } else {
                        System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found");
                    }
                }
                catch (Throwable ex) {
                    System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex);
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private String resolveSystemPropertyPlaceholder(String placeholder) {
        DefaultablePlaceholder dp = new DefaultablePlaceholder(placeholder);
        String value = System.getProperty(dp.placeholder);
        if (value == null) {
            value = System.getenv(dp.placeholder);
        }
        if (value == null) {
            value = dp.defaultValue;
        }
        return value;
    }

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        DefaultablePlaceholder dp = new DefaultablePlaceholder(placeholder);
        String value = super.resolvePlaceholder(dp.placeholder, props, systemPropertiesMode);
        if (value == null) {
            value = dp.defaultValue;
        }
        return value;
    }

    private static class DefaultablePlaceholder {
        private final String defaultValue;
        private final String placeholder;

        public DefaultablePlaceholder(String placeholder) {
            int commaIndex = placeholder.indexOf(":");
            String defaultValue = null;
            if (commaIndex >= 0) {
                defaultValue = StringUtil.trimToEmpty(placeholder.substring(commaIndex + 1));
                placeholder = StringUtil.trimToEmpty(placeholder.substring(0, commaIndex));
            }
            this.placeholder = placeholder;
            this.defaultValue = defaultValue;
        }
    }
}

