/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.BoundedTypeInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBoundedTypeInfo
implements BoundedTypeInfo {
    private static final List<TypeInfo> EMPTY_BOUNDS = Collections.emptyList();
    private final TypeInfo baseType;
    private final List<TypeInfo> upperBounds;

    AbstractBoundedTypeInfo(TypeInfo[] upperBounds) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(upperBounds), "upperBounds is empty", new Object[0]);
        this.upperBounds = Collections.unmodifiableList(Arrays.asList(upperBounds));
        this.baseType = this.upperBounds.get(0);
    }

    @Override
    public TypeInfo getBaseType() {
        return this.baseType;
    }

    @Override
    public Class<?> getRawType() {
        return this.baseType.getRawType();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return this.baseType.isArray();
    }

    @Override
    public boolean isInterface() {
        return this.baseType.isInterface();
    }

    @Override
    public TypeInfo getPrimitiveWrapperType() {
        return this.baseType.getPrimitiveWrapperType();
    }

    @Override
    public TypeInfo getComponentType() {
        return this.baseType.getComponentType();
    }

    @Override
    public TypeInfo getDirectComponentType() {
        return this.baseType.getDirectComponentType();
    }

    @Override
    public int getDimension() {
        return this.baseType.getDimension();
    }

    @Override
    public List<TypeInfo> getInterfaces() {
        return this.baseType.getInterfaces();
    }

    @Override
    public List<TypeInfo> getSuperclasses() {
        return this.baseType.getSuperclasses();
    }

    @Override
    public List<TypeInfo> getSupertypes() {
        return this.baseType.getSupertypes();
    }

    @Override
    public TypeInfo getSupertype(Class<?> equivalentClass) {
        return this.baseType.getSupertype(equivalentClass);
    }

    @Override
    public List<TypeInfo> getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public List<TypeInfo> getLowerBounds() {
        return EMPTY_BOUNDS;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.upperBounds.hashCode() ^ this.getLowerBounds().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractBoundedTypeInfo otherType = (AbstractBoundedTypeInfo)other;
        return this.upperBounds.equals(otherType.upperBounds) && this.getLowerBounds().equals(otherType.getLowerBounds());
    }

    public abstract String toString();
}

