/*
 * Copyright (c) 2002-2012 Alibaba Group Holding Limited.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.citrus.service.pull.support;

import com.alibaba.citrus.service.pull.ToolSetFactory;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.util.Utils;

/**
 * 包含common-util中常用utils的toolset。
 *
 * @author Michael Zhou
 */
public class UtilToolSet implements ToolSetFactory {
    public boolean isSingleton() {
        return true;
    }

    public Iterable<String> getToolNames() {
        return Utils.getUtils().keySet();
    }

    public Object createTool(String name) {
        return Utils.getUtils().get(name);
    }

    public static class DefinitionParser extends AbstractSingleBeanDefinitionParser<UtilToolSet> {
    }
}
