/*
 * Copyright (c) 2002-2012 Alibaba Group Holding Limited.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.citrus.service.moduleloader;

import static com.alibaba.citrus.util.Assert.*;

/**
 * 代表一个模块的信息。
 *
 * @author Michael Zhou
 */
public class ModuleInfo {
    private final String type;
    private final String name;

    public ModuleInfo(String type, String name) {
        this.type = assertNotNull(type, "module type");
        this.name = assertNotNull(name, "module name");
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return type + ":" + name;
    }
}
