/*
 * Copyright (c) 2002-2012 Alibaba Group Holding Limited.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.citrus.service.form.support;

/**
 * 用来检验多值的validator基类。
 *
 * @author Michael Zhou
 */
public abstract class AbstractMultiValuesValidator extends AbstractSimpleCompositeValidator {
    public final boolean validate(Context context) {
        Object[] values = context.getField().getValues();
        return validate(context, values);
    }

    protected abstract boolean validate(Context context, Object[] values);
}
