/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class SetLoggingContextHelper {
    public static final String MDC_METHOD = "method";
    public static final String MDC_REQUEST_URL = "requestURL";
    public static final String MDC_REQUEST_URL_WITH_QUERY_STRING = "requestURLWithQueryString";
    public static final String MDC_REQUEST_URI = "requestURI";
    public static final String MDC_REQUEST_URI_WITH_QUERY_STRING = "requestURIWithQueryString";
    public static final String MDC_QUERY_STRING = "queryString";
    public static final String MDC_REMOTE_ADDR = "remoteAddr";
    public static final String MDC_REMOTE_HOST = "remoteHost";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REFERRER = "referrer";
    public static final String MDC_COOKIES = "cookies";
    public static final String MDC_COOKIE_PREFIX = "cookie.";
    static final String FLAG_MDC_HAS_ALREADY_SET = "_mdc_request_info_has_already_been_set";
    private final HttpServletRequest request;

    public SetLoggingContextHelper(HttpServletRequest request) {
        this.request = Assert.assertNotNull(request, "request", new Object[0]);
    }

    public void setLoggingContext() {
        this.setLoggingContext(null);
    }

    public void setLoggingContext(Map<String, String> extra) {
        boolean setExtra;
        boolean setRequestInfo = this.testAndSetRequestInfo();
        boolean bl = setExtra = extra != null && !extra.isEmpty();
        if (setRequestInfo || setExtra) {
            Map<String, String> mdc = this.getMDCCopy();
            if (setRequestInfo) {
                this.setRequestInfo(mdc);
            }
            if (setExtra) {
                mdc.putAll(extra);
            }
            this.setMDC(mdc);
        }
    }

    public void clearLoggingContext() {
        if (this == this.request.getAttribute(FLAG_MDC_HAS_ALREADY_SET)) {
            this.request.removeAttribute(FLAG_MDC_HAS_ALREADY_SET);
            this.clearMDC();
        }
    }

    protected void setRequestInfo(Map<String, String> mdc) {
        this.putMDC(mdc, MDC_METHOD, this.request.getMethod());
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = StringUtil.trimToNull(this.request.getQueryString());
        this.putMDC(mdc, MDC_REQUEST_URL, this.getRequestURL(requestURL, null));
        this.putMDC(mdc, MDC_REQUEST_URL_WITH_QUERY_STRING, this.getRequestURL(requestURL, queryString));
        String requestURI = this.request.getRequestURI();
        String requestURIWithQueryString = queryString == null ? requestURI : requestURI + "?" + queryString;
        this.putMDC(mdc, MDC_REQUEST_URI, requestURI);
        this.putMDC(mdc, MDC_REQUEST_URI_WITH_QUERY_STRING, requestURIWithQueryString);
        this.putMDC(mdc, MDC_QUERY_STRING, queryString);
        this.putMDC(mdc, MDC_REMOTE_HOST, this.request.getRemoteHost());
        this.putMDC(mdc, MDC_REMOTE_ADDR, this.request.getRemoteAddr());
        this.putMDC(mdc, MDC_USER_AGENT, this.request.getHeader("User-Agent"));
        this.putMDC(mdc, MDC_REFERRER, this.request.getHeader("Referer"));
        Cookie[] cookies = this.request.getCookies();
        List names = Collections.emptyList();
        if (cookies != null) {
            names = CollectionUtil.createArrayList(cookies.length);
            for (Cookie cookie : cookies) {
                names.add(cookie.getName());
                this.putMDC(mdc, MDC_COOKIE_PREFIX + cookie.getName(), cookie.getValue());
            }
            Collections.sort(names);
        }
        this.putMDC(mdc, MDC_COOKIES, names.toString());
    }

    private boolean testAndSetRequestInfo() {
        if (this.request.getAttribute(FLAG_MDC_HAS_ALREADY_SET) == null) {
            this.request.setAttribute(FLAG_MDC_HAS_ALREADY_SET, (Object)this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestURL(StringBuffer requestURL, String queryString) {
        int length = requestURL.length();
        try {
            if (queryString != null) {
                requestURL.append('?').append(queryString);
            }
            String string = requestURL.toString();
            return string;
        }
        finally {
            requestURL.setLength(length);
        }
    }

    private void putMDC(Map<String, String> mdc, String key, String value) {
        if (value != null) {
            mdc.put(key, value);
        }
    }

    protected Map<String, String> getMDCCopy() {
        HashMap<String, String> mdc = MDC.getCopyOfContextMap();
        if (mdc == null) {
            mdc = CollectionUtil.createHashMap();
        }
        return mdc;
    }

    protected void setMDC(Map<String, String> mdc) {
        MDC.setContextMap(mdc);
    }

    protected void clearMDC() {
        MDC.clear();
    }
}

