/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class ErrorHandlerHelper {
    public static final String KEY_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String KEY_MESSAGE = "javax.servlet.error.message";
    public static final String KEY_EXCEPTION = "javax.servlet.error.exception";
    public static final String KEY_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String KEY_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String KEY_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String KEY_ERROR_HANDLER_HELPER = "_webx_errorHandlerHelper_";
    public static final Map<Integer, String> STATUS_CODE_MESSAGES = ErrorHandlerHelper.getCodeMessages();
    private final HttpServletRequest request;
    private int statusCode;
    private String message;
    private Throwable exception;
    private Class<?> exceptionType;
    private String requestURI;
    private String servletName;

    private ErrorHandlerHelper(HttpServletRequest request) {
        this.request = request;
    }

    public static ErrorHandlerHelper getInstance(HttpServletRequest request) {
        ErrorHandlerHelper helper = (ErrorHandlerHelper)Assert.assertNotNull(request, "request", new Object[0]).getAttribute(KEY_ERROR_HANDLER_HELPER);
        if (helper == null) {
            helper = new ErrorHandlerHelper(request);
            request.setAttribute(KEY_ERROR_HANDLER_HELPER, (Object)helper);
        }
        return helper;
    }

    public void init(String servletName, Throwable exception, ExceptionCodeMapping mapping) {
        this.setRequestURI(this.request.getRequestURI());
        this.setServletName(servletName);
        this.setException(Assert.assertNotNull(exception, "exception", new Object[0]));
        int statusCode = 500;
        if (mapping != null) {
            for (Throwable e : ExceptionUtil.getCauses(exception, true)) {
                int mappedCode = mapping.getExceptionCode(e);
                if (mappedCode <= 0) continue;
                statusCode = mappedCode;
                break;
            }
        }
        this.setStatusCode(statusCode);
    }

    public void setServletErrorAttributes() {
        this.setAttribute(KEY_STATUS_CODE, this.getStatusCode());
        this.setAttribute(KEY_MESSAGE, this.getMessage());
        this.setAttribute(KEY_EXCEPTION, this.getException());
        this.setAttribute(KEY_EXCEPTION_TYPE, this.getExceptionType());
        this.setAttribute(KEY_REQUEST_URI, this.getRequestURI());
        this.setAttribute(KEY_SERVLET_NAME, this.getServletName());
    }

    private void setAttribute(String key, Object value) {
        if (value == null) {
            this.request.removeAttribute(key);
        } else {
            this.request.setAttribute(key, value);
        }
    }

    public int getStatusCode() {
        if (this.statusCode <= 0) {
            return 500;
        }
        return this.statusCode;
    }

    public String getMessage() {
        if (this.message == null) {
            return STATUS_CODE_MESSAGES.get(this.getStatusCode());
        }
        return this.message;
    }

    public void setStatusCode(int sc) {
        this.setStatusCode(sc, null);
    }

    public void setStatusCode(int sc, String message) {
        Integer code;
        Integer n = code = sc <= 0 ? null : Integer.valueOf(sc);
        if (message == null) {
            message = STATUS_CODE_MESSAGES.get(code);
        }
        this.statusCode = code;
        this.message = message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Class<?> getExceptionType() {
        return this.exceptionType;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
        this.exceptionType = exception == null ? null : exception.getClass();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    private static Map<Integer, String> getCodeMessages() {
        TreeMap<Integer, String> messages = CollectionUtil.createTreeMap();
        int constantMask = 25;
        for (Field field : HttpServletResponse.class.getFields()) {
            Class<?> type = field.getType();
            String name = field.getName();
            int modifiers = field.getModifiers() & constantMask;
            if (modifiers != constantMask || !name.startsWith("SC_") || !Integer.TYPE.equals(type)) continue;
            try {
                Integer sc = (Integer)field.get(null);
                String message = name.substring("SC_".length());
                messages.put(sc, message);
            }
            catch (Exception e) {
                Assert.unexpectedException(e);
            }
        }
        return messages;
    }

    public void logError(Logger log) {
        this.logError(log, null);
    }

    public void logError(Logger log, LoggingDetail detail) {
        Throwable e = this.getException();
        if (e == null) {
            return;
        }
        if (detail == null) {
            detail = LoggingDetail.detailed;
        }
        switch (detail) {
            case detailed: {
                log.error("Failed to process request " + this.getRequestURI() + ", the root cause was " + this.getRootCauseMessage(), this.getException());
                break;
            }
            case brief: {
                log.error(this.getRootCauseMessage());
                break;
            }
        }
    }

    private String getRootCauseMessage() {
        Throwable rootCause = ExceptionUtil.getRootCause(this.getException());
        String message = rootCause.getClass().getSimpleName();
        if (!StringUtil.isBlank(rootCause.getMessage())) {
            message = message + ": " + rootCause.getMessage();
        }
        return message;
    }

    public String toString() {
        return this.getStatusCode() + " " + this.getMessage();
    }

    public static enum LoggingDetail {
        detailed,
        brief,
        disabled;

    }

    public static interface ExceptionCodeMapping {
        public int getExceptionCode(Throwable var1);
    }
}

