/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.servlet;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class FilterBean
implements Filter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> requiredProperties = CollectionUtil.createHashSet();
    private FilterConfig filterConfig;

    protected final void addRequiredProperty(String name) {
        this.requiredProperties.add(name);
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.logInBothServletAndLoggingSystem("Initializing filter: " + this.getFilterName());
        try {
            FilterConfigPropertyValues pvs = new FilterConfigPropertyValues(this.getFilterConfig(), this.requiredProperties);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
            ServletContextResourceLoader resourceLoader = new ServletContextResourceLoader(this.getServletContext());
            bw.registerCustomEditor(Resource.class, (PropertyEditor)new ResourceEditor((ResourceLoader)resourceLoader));
            this.initBeanWrapper(bw);
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (Exception e) {
            throw new ServletException("Failed to set bean properties on filter: " + this.getFilterName(), (Throwable)e);
        }
        try {
            this.init();
        }
        catch (Exception e) {
            throw new ServletException("Failed to init filter: " + this.getFilterName(), (Throwable)e);
        }
        this.logInBothServletAndLoggingSystem(this.getClass().getSimpleName() + " - " + this.getFilterName() + ": initialization completed");
    }

    protected final void logInBothServletAndLoggingSystem(String msg) {
        this.getServletContext().log(msg);
        this.log.info(msg);
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
    }

    protected void init() throws Exception {
    }

    public void destroy() {
    }

    public final FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public final String getFilterName() {
        return this.filterConfig == null ? null : this.filterConfig.getFilterName();
    }

    public final ServletContext getServletContext() {
        return this.filterConfig == null ? null : this.filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Object httpResponse = (HttpServletResponse)response;
            String method = httpRequest.getMethod();
            if ("HEAD".equalsIgnoreCase(method)) {
                httpResponse = new NoBodyResponse((HttpServletResponse)httpResponse);
            }
            try {
                this.doFilter(httpRequest, (HttpServletResponse)httpResponse, chain);
            }
            finally {
                if (httpResponse instanceof NoBodyResponse) {
                    ((NoBodyResponse)((Object)httpResponse)).setContentLength();
                }
            }
        } else {
            this.log.debug("Skipped filtering due to the unknown request/response types: {}, {}", (Object)request.getClass().getName(), (Object)response.getClass().getName());
            chain.doFilter(request, response);
        }
    }

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private static class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        public int getContentLength() {
            return this.contentLength;
        }

        public void write(int b) {
            ++this.contentLength;
        }

        public void write(byte[] buf, int offset, int len) throws IOException {
            if (len >= 0) {
                this.contentLength += len;
            } else {
                throw new IOException("negative length");
            }
        }
    }

    private static class NoBodyResponse
    extends HttpServletResponseWrapper {
        private NoBodyOutputStream noBody = new NoBodyOutputStream();
        private PrintWriter writer;
        private boolean didSetContentLength;

        public NoBodyResponse(HttpServletResponse response) {
            super(response);
        }

        public void setContentLength() {
            if (!this.didSetContentLength) {
                super.setContentLength(this.noBody.getContentLength());
            }
        }

        public void setContentLength(int len) {
            super.setContentLength(len);
            this.didSetContentLength = true;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.noBody;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.noBody), this.getCharacterEncoding()));
            }
            return this.writer;
        }
    }

    private static class FilterConfigPropertyValues
    extends MutablePropertyValues {
        private static final long serialVersionUID = -5359131251714023794L;

        public FilterConfigPropertyValues(FilterConfig config, Set<String> requiredProperties) throws ServletException {
            TreeSet<String> missingProps = CollectionUtil.createTreeSet(requiredProperties);
            Enumeration e = config.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = config.getInitParameter(key);
                this.addPropertyValue(new PropertyValue(key, (Object)value));
                missingProps.remove(key);
            }
            Assert.assertTrue(missingProps.isEmpty(), "Initialization for filter %s failed.  The following required properties were missing: %s", config.getFilterName(), missingProps);
        }
    }
}

