/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.KeyValuesComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestComponent
extends PageComponent {
    private final KeyValuesComponent keyValuesComponent;

    public RequestComponent(PageComponentRegistry registry, String componentPath, KeyValuesComponent keyValuesComponent) {
        super(registry, componentPath);
        this.keyValuesComponent = keyValuesComponent;
    }

    public void visitTemplate(RequestHandlerContext context) {
        this.getTemplate().accept(new RequestVisitor(context));
    }

    private class RequestVisitor
    extends AbstractVisitor {
        private final HttpServletRequest request;
        private final ServletContext servletContext;

        public RequestVisitor(RequestHandlerContext context) {
            super(context, RequestComponent.this);
            this.request = context.getRequest();
            this.servletContext = context.getServletContext();
        }

        public void visitBasicInfo() {
            LinkedHashMap<String, String> keyValues = CollectionUtil.createLinkedHashMap();
            keyValues.put("Method", this.request.getMethod());
            keyValues.put("Protocol", this.request.getProtocol());
            keyValues.put("Request URL", this.request.getRequestURL().toString());
            keyValues.put("Query String", this.request.getQueryString());
            keyValues.put("Scheme", this.request.getScheme());
            keyValues.put("Server Name", this.request.getServerName());
            keyValues.put("Server Port", String.valueOf(this.request.getServerPort()));
            keyValues.put("Context Path", this.request.getContextPath());
            keyValues.put("Servlet Path", this.request.getServletPath());
            keyValues.put("Path Info", this.request.getPathInfo());
            keyValues.put("Path Translated", this.request.getPathTranslated());
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitConnectionInfo() {
            LinkedHashMap<String, String> keyValues = CollectionUtil.createLinkedHashMap();
            keyValues.put("Local Name", this.request.getLocalName());
            keyValues.put("Local Address", this.request.getLocalAddr());
            keyValues.put("Local Port", String.valueOf(this.request.getLocalPort()));
            keyValues.put("Remote Host", this.request.getRemoteHost());
            keyValues.put("Remote Address", this.request.getRemoteAddr());
            keyValues.put("Remote Port", String.valueOf(this.request.getRemotePort()));
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitAuthInfo() {
            LinkedHashMap<String, String> keyValues = CollectionUtil.createLinkedHashMap();
            keyValues.put("Remote User", this.request.getRemoteUser());
            keyValues.put("Auth Type", this.request.getAuthType());
            keyValues.put("User Principal", String.valueOf(this.request.getUserPrincipal()));
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitMisc() {
            LinkedHashMap<String, Object> keyValues = CollectionUtil.createLinkedHashMap();
            keyValues.put("Character Encoding", this.request.getCharacterEncoding());
            keyValues.put("Content Length", String.valueOf(this.request.getContentLength()));
            keyValues.put("Content Type", this.request.getContentType());
            keyValues.put("Preferred Locale", String.valueOf(this.request.getLocale()));
            keyValues.put("Supported Locales", this.enumToList(this.request.getLocales()));
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitParameters() {
            TreeMap keyValues = CollectionUtil.createTreeMap();
            for (String name : this.enumToList(this.request.getParameterNames())) {
                keyValues.put(name, CollectionUtil.createArrayList(this.request.getParameterValues(name)));
            }
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitHeaders() {
            TreeMap<String, List<String>> keyValues = CollectionUtil.createTreeMap();
            for (String name : this.enumToList(this.request.getHeaderNames())) {
                keyValues.put(name, this.enumToList(this.request.getHeaders(name)));
            }
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitCookies() {
            TreeMap<String, String> keyValues = CollectionUtil.createTreeMap();
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    keyValues.put(cookie.getName(), cookie.getValue());
                }
            }
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitAttributes() {
            TreeMap<String, Object> keyValues = CollectionUtil.createTreeMap();
            for (String name : this.enumToList(this.request.getAttributeNames())) {
                keyValues.put(name, this.request.getAttribute(name));
            }
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        public void visitContextAttributes() {
            TreeMap<String, String> keyValues = CollectionUtil.createTreeMap();
            for (String name : this.enumToList(this.servletContext.getAttributeNames())) {
                keyValues.put(name, String.valueOf(this.servletContext.getAttribute(name)));
            }
            RequestComponent.this.keyValuesComponent.visitTemplate(this.context, keyValues);
        }

        private List<String> enumToList(Enumeration<?> i) {
            ArrayList<String> list = CollectionUtil.createArrayList();
            if (i != null) {
                while (i.hasMoreElements()) {
                    list.add(String.valueOf(i.nextElement()));
                }
            }
            return list;
        }
    }
}

