/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.templatelite;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.templatelite.FallbackVisitor;
import com.alibaba.citrus.util.templatelite.TemplateParseException;
import com.alibaba.citrus.util.templatelite.TemplateRuntimeException;
import com.alibaba.citrus.util.templatelite.TextWriter;
import com.alibaba.citrus.util.templatelite.VisitorInvocationErrorHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cglib.reflect.FastClass;

public final class Template {
    private static final int MAX_REDIRECT_DEPTH = 10;
    private static final Node[] EMPTY_NODES = new Node[0];
    private static final Map<String, Template> predefinedTemplates = CollectionUtil.createHashMap();
    private final String name;
    final InputSource source;
    final Location location;
    final Template ref;
    Node[] nodes;
    Map<String, Template> subtemplates;
    Map<String, String> params;

    public Template(File source) {
        this(new InputSource(source, null), null);
    }

    public Template(URL source) {
        this(new InputSource(source, null), null);
    }

    public Template(InputStream stream, String systemId) {
        this(new InputSource(stream, systemId), null);
    }

    public Template(Reader reader, String systemId) {
        this(new InputSource(reader, systemId), null);
    }

    private Template(InputSource source, String name) {
        this.name = StringUtil.trimToNull(name);
        this.source = Assert.assertNotNull(source, "source", new Object[0]);
        this.location = new Location(source.systemId, 0, 0);
        this.ref = null;
        source.reloadIfNecessary(this);
    }

    private Template(String name, Node[] nodes, Map<String, String> params, Map<String, Template> subtemplates, Location location) {
        this.name = StringUtil.trimToNull(name);
        this.source = null;
        this.location = Assert.assertNotNull(location, "location", new Object[0]);
        this.ref = null;
        this.update(nodes, params, subtemplates);
    }

    private Template(Template ref) {
        this.ref = Assert.assertNotNull(ref, "template ref", new Object[0]);
        this.name = null;
        this.source = null;
        this.location = null;
        this.nodes = null;
        this.subtemplates = null;
        this.params = null;
    }

    private void assertNotRef() {
        Assert.assertNull(this.ref, Assert.ExceptionType.UNSUPPORTED_OPERATION, "template ref", new Object[0]);
    }

    private void update(Node[] nodes, Map<String, String> params, Map<String, Template> subtemplates) {
        this.assertNotRef();
        this.nodes = ArrayUtil.defaultIfEmptyArray(nodes, EMPTY_NODES);
        this.params = CollectionUtil.createArrayHashMap(Assert.assertNotNull(params, "params", new Object[0]).size());
        this.subtemplates = CollectionUtil.createArrayHashMap(Assert.assertNotNull(subtemplates, "subtemplates", new Object[0]).size());
        this.params.putAll(params);
        this.subtemplates.putAll(subtemplates);
    }

    public String getName() {
        if (this.ref == null) {
            return this.name;
        }
        return this.ref.name;
    }

    public String getParameter(String name) {
        if (this.ref == null) {
            return this.params.get(name);
        }
        return this.ref.params.get(name);
    }

    public Template getSubTemplate(String name) {
        if (this.ref == null) {
            return this.subtemplates.get(name);
        }
        return this.ref.subtemplates.get(name);
    }

    public String renderToString(TextWriter<? super StringBuilder> writer) {
        writer.setOut(new StringBuilder());
        this.accept(writer);
        return ((Object)writer.out()).toString();
    }

    public void accept(Object visitor) throws TemplateRuntimeException {
        if (this.ref == null) {
            if (this.source != null) {
                this.source.reloadIfNecessary(this);
            }
            for (Node node : this.nodes) {
                this.invokeVisitor(visitor, node);
            }
        } else {
            this.invokeVisitor(visitor, this.ref);
        }
    }

    private void invokeVisitor(Object visitor, Template templateRef) throws TemplateRuntimeException {
        this.invokeVisitor(visitor, templateRef, 0);
    }

    private void invokeVisitor(Object visitor, Node node) throws TemplateRuntimeException {
        this.assertNotRef();
        this.invokeVisitor(visitor, node, 0);
    }

    /*
     * Unable to fully structure code
     */
    private void invokeVisitor(Object visitor, Object node, int redirectDepth) throws TemplateRuntimeException {
        block21: {
            if (node instanceof IncludeTemplate) {
                Assert.assertNotNull(((IncludeTemplate)node).includedTemplate).accept(visitor);
                return;
            }
            visitorClass = Assert.assertNotNull(visitor, "visitor is null", new Object[0]).getClass();
            try {
                method = null;
                params = null;
                if (node instanceof Text) {
                    text = (Text)node;
                    method = this.findVisitTextMethod(visitorClass, "visitText");
                    params = new Object[]{text.text};
                } else if (node instanceof Template) {
                    ref = (Template)node;
                    method = this.findVisitTemplateMethod(visitorClass, "visit" + StringUtil.trimToEmpty(StringUtil.capitalize(ref.getName())));
                    if (method == null) {
                        ref.accept(visitor);
                        return;
                    }
                    params = new Object[]{ref};
                } else if (node instanceof Placeholder) {
                    placeholder = (Placeholder)node;
                    placeholderParamCount = placeholder.params.length;
                    methodName = "visit" + StringUtil.trimToEmpty(StringUtil.capitalize(placeholder.name));
                    try {
                        method = this.findVisitPlaceholderMethod(visitorClass, methodName, placeholder.params);
                        methodParamCount = method.getParameterTypes().length;
                        if (method.getParameterTypes().length == 0) {
                            params = BasicConstant.EMPTY_OBJECT_ARRAY;
                        }
                        if (method.getParameterTypes()[0].isArray()) {
                            array = method.getParameterTypes()[0].equals(String[].class) != false ? new String[placeholderParamCount] : (method.getParameterTypes()[0].equals(Template[].class) != false ? new Template[placeholderParamCount] : new Object[placeholderParamCount]);
                            params = new Object[]{this.toPlaceholderParameterValues(placeholder, array)};
                        }
                        params = this.toPlaceholderParameterValues(placeholder, new Object[methodParamCount]);
                    }
                    catch (NoSuchMethodException e) {
                        processed = false;
                        if (visitor instanceof FallbackVisitor) {
                            processed = ((FallbackVisitor)visitor).visitPlaceholder(placeholder.name, this.toPlaceholderParameterValues(placeholder, new Object[placeholderParamCount]));
                        }
                        if (processed) ** GOTO lbl45
                        throw e;
                    }
                } else {
                    Assert.unreachableCode("Unexpected node type: " + node.getClass().getName(), new Object[0]);
                }
lbl45:
                // 7 sources

                if (method == null) break block21;
                newVisitor = null;
                try {
                    newVisitor = FastClass.create(visitorClass).getMethod(method).invoke(visitor, params);
                }
                catch (InvocationTargetException e) {
                    if (visitor instanceof VisitorInvocationErrorHandler) {
                        ((VisitorInvocationErrorHandler)visitor).handleInvocationError(node.toString(), e.getCause());
                    }
                    throw new TemplateRuntimeException("Error rendering " + node, e.getCause());
                }
                if (newVisitor != null && visitor != newVisitor) {
                    if (redirectDepth >= 10) {
                        throw new TemplateRuntimeException("Redirection out of control (depth>10) in " + method);
                    }
                    this.invokeVisitor(newVisitor, node, redirectDepth + 1);
                }
            }
            catch (TemplateRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateRuntimeException("Error rendering " + node, e);
            }
        }
    }

    private Method findVisitTextMethod(Class<?> visitorClass, String methodName) throws NoSuchMethodException {
        Method method = null;
        for (Method candidateMethod : visitorClass.getMethods()) {
            Class<?>[] paramTypes;
            int paramsCount;
            if (!methodName.equals(candidateMethod.getName()) || (paramsCount = (paramTypes = candidateMethod.getParameterTypes()).length) != 1 || !paramTypes[0].equals(String.class)) continue;
            method = candidateMethod;
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException(visitorClass.getSimpleName() + "." + methodName + "(String)");
        }
        return method;
    }

    private Method findVisitTemplateMethod(Class<?> visitorClass, String methodName) throws NoSuchMethodException {
        Method method = null;
        for (Method candidateMethod : visitorClass.getMethods()) {
            Class<?>[] paramTypes;
            int paramsCount;
            if (!methodName.equals(candidateMethod.getName()) || (paramsCount = (paramTypes = candidateMethod.getParameterTypes()).length) != 1 || !paramTypes[0].equals(Template.class)) continue;
            method = candidateMethod;
            break;
        }
        return method;
    }

    private Method findVisitPlaceholderMethod(Class<?> visitorClass, String methodName, PlaceholderParameter[] placeholderParams) throws NoSuchMethodException {
        Method[] methods = visitorClass.getMethods();
        Class[] placeholderParamTypes = new Class[placeholderParams.length];
        int placeholderParamCount = placeholderParamTypes.length;
        int placeholderParamStringCount = 0;
        int placeholderParamTemplateCount = 0;
        for (int i = 0; i < placeholderParamCount; ++i) {
            PlaceholderParameter param = placeholderParams[i];
            if (param.isTemplateReference()) {
                ++placeholderParamTemplateCount;
                placeholderParamTypes[i] = Template.class;
                continue;
            }
            ++placeholderParamStringCount;
            placeholderParamTypes[i] = String.class;
        }
        Method method = null;
        int minIndexWeight = Integer.MAX_VALUE;
        for (Method candidateMethod : methods) {
            if (!methodName.equals(candidateMethod.getName())) continue;
            Class<?>[] methodParamTypes = candidateMethod.getParameterTypes();
            int methodParamCount = methodParamTypes.length;
            boolean paramTypeMatches = false;
            int indexWeight = Integer.MAX_VALUE;
            switch (methodParamCount) {
                case 0: {
                    paramTypeMatches = true;
                    indexWeight = 100000 * Math.abs(methodParamCount - placeholderParamCount);
                    break;
                }
                case 1: {
                    if (placeholderParamStringCount == placeholderParamCount && methodParamTypes[0].equals(String[].class)) {
                        paramTypeMatches = true;
                        indexWeight = 50;
                    }
                    if (placeholderParamTemplateCount == placeholderParamCount && methodParamTypes[0].equals(Template[].class)) {
                        paramTypeMatches = true;
                        indexWeight = 50;
                    }
                    if (methodParamTypes[0].equals(Object[].class)) {
                        paramTypeMatches = true;
                        indexWeight = 90;
                    }
                }
                default: {
                    if (paramTypeMatches) break;
                    paramTypeMatches = true;
                    for (int i = 0; i < methodParamCount; ++i) {
                        if (i < placeholderParamCount) {
                            if (methodParamTypes[i].equals(placeholderParamTypes[i])) continue;
                            paramTypeMatches = false;
                            break;
                        }
                        if (methodParamTypes[i].equals(String.class) || methodParamTypes[i].equals(Template.class)) continue;
                        paramTypeMatches = false;
                        break;
                    }
                    if (!paramTypeMatches) break;
                    indexWeight = 100 * Math.abs(methodParamCount - placeholderParamCount);
                }
            }
            if (!paramTypeMatches || indexWeight >= minIndexWeight) continue;
            minIndexWeight = indexWeight;
            method = candidateMethod;
            if (indexWeight == 0) break;
        }
        if (method == null) {
            StringBuilder buf = new StringBuilder();
            Formatter format = new Formatter(buf);
            int count = 1;
            buf.append("One of the following method:\n");
            format.format("  %d. %s.%s(", count++, visitorClass.getSimpleName(), methodName);
            for (int i = 0; i < placeholderParamCount; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(placeholderParamTypes[i].getSimpleName());
            }
            buf.append(")\n");
            format.format("  %d. %s.%s(", count++, visitorClass.getSimpleName(), methodName);
            if (placeholderParamStringCount == placeholderParamCount) {
                buf.append("String");
            } else if (placeholderParamTemplateCount == placeholderParamCount) {
                buf.append("Template");
            } else {
                buf.append("Object");
            }
            buf.append("[])\n");
            if (placeholderParamCount > 0) {
                format.format("  %d. %s.%s()", count++, visitorClass.getSimpleName(), methodName);
            }
            if (buf.charAt(buf.length() - 1) == '\n') {
                buf.setLength(buf.length() - 1);
            }
            throw new NoSuchMethodException(buf.toString());
        }
        return method;
    }

    private Object[] toPlaceholderParameterValues(Placeholder placeholder, Object[] params) {
        for (int i = 0; i < params.length && i < placeholder.params.length; ++i) {
            PlaceholderParameter param = placeholder.params[i];
            params[i] = param.isTemplateReference() ? Assert.assertNotNull(param.getTemplateReference()) : param.getValue();
        }
        return params;
    }

    public String toString() {
        if (this.ref == null) {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("params", this.params.entrySet());
            mb.append("nodes", this.nodes);
            mb.append("sub-templates", this.subtemplates.values());
            return new ToStringBuilder().format("#%s with %d nodes at %s", this.name == null ? "(template)" : this.name, this.nodes.length, this.location).append(mb).toString();
        }
        return "ref to " + this.ref;
    }

    private static void predefineTemplate(String name, String text) {
        Template template = new Template(name, new Node[]{new Text(text, new Location(null, 1, 1))}, Collections.<String, String>emptyMap(), Collections.<String, Template>emptyMap(), new Location(null, 1, 1));
        predefinedTemplates.put(name, template);
    }

    static {
        Template.predefineTemplate("SPACE", " ");
        Template.predefineTemplate("BR", "\n");
    }

    static class InputSource {
        private static final Pattern CHARSET_DETECTIVE_PATTERN = Pattern.compile("^(\\s*##)|^(\\s*)#@\\s*(\\w+)\\s+(.*?)\\s*(##.*)?$|^\\s*$");
        private long lastModified = 0L;
        final String systemId;
        Object source;

        public InputSource(File source) {
            this(source, null);
        }

        public InputSource(URL source) {
            this(source, null);
        }

        public InputSource(InputStream source, String systemId) {
            this((Object)source, systemId);
        }

        public InputSource(Reader source, String systemId) {
            this((Object)source, systemId);
        }

        private InputSource(Object source, String systemId) {
            Assert.assertNotNull(source, "source", new Object[0]);
            if (source instanceof URL) {
                try {
                    this.source = new File(((URL)source).toURI().normalize());
                }
                catch (Exception e) {
                    this.source = source;
                }
            } else {
                this.source = source instanceof File ? new File(((File)source).toURI().normalize()) : source;
            }
            this.systemId = this.source instanceof URL ? ((URL)this.source).toExternalForm() : (this.source instanceof File ? ((File)this.source).toURI().toString() : StringUtil.trimToNull(systemId));
        }

        private void reloadIfNecessary(Template template) {
            Assert.assertNotNull(template, "template", new Object[0]);
            Assert.assertTrue(template.source == this);
            boolean doLoad = false;
            if (template.nodes == null) {
                doLoad = true;
            } else if (this.source instanceof File && ((File)this.source).lastModified() != this.lastModified) {
                doLoad = true;
            }
            if (doLoad) {
                Reader reader;
                try {
                    reader = this.getReader();
                }
                catch (IOException e) {
                    throw new TemplateParseException(e);
                }
                new Parser(reader, this.systemId, this).parse().updateTemplate(template);
                if (this.source instanceof File) {
                    this.lastModified = ((File)this.source).lastModified();
                }
            }
        }

        InputSource getRelative(String relativePath) throws Exception {
            if ((relativePath = StringUtil.trimToNull(relativePath)) != null) {
                String sourceURI = null;
                if (this.source instanceof File) {
                    sourceURI = ((File)this.source).toURI().toString();
                } else if (this.source instanceof URL) {
                    sourceURI = ((URL)this.source).toExternalForm();
                }
                if (sourceURI != null) {
                    return new InputSource(new URL(FileUtil.resolve(sourceURI, relativePath)));
                }
            }
            return null;
        }

        Reader getReader() throws IOException {
            Reader reader;
            if (this.source instanceof Reader) {
                reader = (Reader)this.source;
                this.source = null;
            } else {
                BufferedInputStream istream = null;
                if (this.source instanceof File) {
                    istream = new BufferedInputStream(new FileInputStream((File)this.source));
                } else if (this.source instanceof URL) {
                    try {
                        this.source = new File(((URL)this.source).toURI());
                        istream = new BufferedInputStream(new FileInputStream((File)this.source));
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                    if (istream == null) {
                        istream = new BufferedInputStream(((URL)this.source).openStream());
                    }
                } else if (this.source instanceof InputStream) {
                    istream = new BufferedInputStream((InputStream)this.source);
                    this.source = null;
                } else {
                    throw new IllegalStateException("Unknown source: " + this.source);
                }
                String charset = InputSource.detectCharset(istream, "UTF-8");
                reader = new InputStreamReader((InputStream)istream, charset);
            }
            return reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String detectCharset(BufferedInputStream istream, String defaultCharset) throws IOException {
            int readlimit = 4096;
            istream.mark(readlimit);
            StringBuilder buf = new StringBuilder(readlimit);
            try {
                int c;
                for (int i = 0; i < readlimit && (c = istream.read()) != -1; ++i) {
                    if (c == 13 || c == 10) {
                        String line = buf.toString();
                        buf.setLength(0);
                        Matcher matcher = CHARSET_DETECTIVE_PATTERN.matcher(line);
                        if (!matcher.find()) break;
                        String charset = null;
                        if ("charset".equals(matcher.group(3))) {
                            charset = matcher.group(4);
                        }
                        if (charset == null) continue;
                        String string = charset;
                        return string;
                    }
                    buf.append((char)c);
                }
            }
            finally {
                istream.reset();
            }
            return defaultCharset;
        }
    }

    private static class ParsingTemplate {
        private final String systemId;
        private final int lineNumber;
        private final int columnNumber;
        private final String name;
        private final LinkedList<Node> nodes = CollectionUtil.createLinkedList();
        private final Map<String, String> params = CollectionUtil.createTreeMap();
        private final Map<String, Template> subtemplates = CollectionUtil.createArrayHashMap();

        public ParsingTemplate(String name, String systemId, int lineNumber, int columnNumber, Map<String, String> parentParams) {
            this.name = name;
            this.systemId = systemId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            if (parentParams != null) {
                this.params.putAll(parentParams);
            }
        }

        public void addNode(Node node) {
            if (node != null) {
                if (!this.subtemplates.isEmpty()) {
                    if (node.location.lineNumber > 0) {
                        throw new TemplateParseException("Invalid " + node.desc() + " here at " + node.location);
                    }
                } else if (node instanceof Text && !this.nodes.isEmpty() && this.nodes.getLast() instanceof Text) {
                    Text lastNode = (Text)this.nodes.removeLast();
                    Text thisNode = (Text)node;
                    Location location = lastNode.location.lineNumber > 0 ? lastNode.location : node.location;
                    this.nodes.add(new Text(lastNode.text + thisNode.text, location));
                } else {
                    this.nodes.add(node);
                }
            }
        }

        public void addParam(String name, String value, int lineNumber, int columnNumber) {
            if (!this.subtemplates.isEmpty() || this.hasNonEmptyNode()) {
                throw new TemplateParseException("Invalid #@" + name + " here at " + Location.toString(this.systemId, lineNumber, columnNumber));
            }
            this.params.put(name, StringUtil.trimToEmpty(value));
        }

        public void addSubTemplate(Template template) {
            this.subtemplates.put(template.getName(), template);
        }

        public Template getSubTemplate(String name) {
            return this.subtemplates.get(name);
        }

        private boolean hasNonEmptyNode() {
            for (Node node : this.nodes) {
                if (node.location.lineNumber <= 0) continue;
                return true;
            }
            return false;
        }

        public Template toTemplate() {
            return new Template(this.name, this.nodes.toArray(new Node[this.nodes.size()]), this.params, this.subtemplates, new Location(this.systemId, this.lineNumber, this.columnNumber));
        }

        public void updateTemplate(Template template) {
            template.update(this.nodes.toArray(new Node[this.nodes.size()]), this.params, this.subtemplates);
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("name", this.name);
            mb.append("systemId", this.systemId);
            mb.append("lineNumber", this.lineNumber);
            mb.append("columnNumber", this.columnNumber);
            mb.append("nodes", this.nodes);
            mb.append("params", this.params);
            mb.append("sub-templates", this.subtemplates);
            return new ToStringBuilder().append("Template").append(mb).toString();
        }
    }

    private static class ParsingTemplateStack {
        private final LinkedList<ParsingTemplate> stack = CollectionUtil.createLinkedList();

        private ParsingTemplateStack() {
        }

        public void push(ParsingTemplate pt) {
            Template duplicatedTemplate;
            ParsingTemplate currentParsingTemplate = this.peek();
            if (currentParsingTemplate != null && (duplicatedTemplate = currentParsingTemplate.getSubTemplate(pt.name)) != null) {
                throw new TemplateParseException("Duplicated template name #" + pt.name + " at " + Location.toString(pt.systemId, pt.lineNumber, pt.columnNumber) + ".  Another template with the same name is located in " + duplicatedTemplate.location);
            }
            this.stack.addLast(pt);
        }

        public ParsingTemplate peek() {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.getLast();
        }

        public int size() {
            return this.stack.size();
        }

        public Template pop() {
            return this.stack.removeLast().toTemplate();
        }

        public String toString() {
            return new ToStringBuilder().append(this.stack).toString();
        }
    }

    private static class TextBuffer {
        private final StringBuilder buf = new StringBuilder();
        private final String systemId;
        private int lineNumber = -1;
        private int columnNumber = -1;

        public TextBuffer(String systemId) {
            this.systemId = systemId;
        }

        public void append(String s, int lineNumber, int columnNumber) {
            this.append(s, 0, s.length(), lineNumber, columnNumber);
        }

        public void append(CharSequence s, int start, int end, int lineNumber, int columnNumber) {
            this.buf.append(s, start, end);
            if (this.lineNumber == -1 || this.columnNumber == -1) {
                for (int i = start; i < end; ++i) {
                    char c = s.charAt(i);
                    if (Character.isWhitespace(c)) {
                        ++columnNumber;
                        continue;
                    }
                    this.lineNumber = lineNumber;
                    this.columnNumber = columnNumber;
                    break;
                }
            }
        }

        public void newLine() {
            this.buf.append("\n");
        }

        public void clear() {
            this.buf.setLength(0);
            this.lineNumber = -1;
            this.columnNumber = -1;
        }

        public Text toText() {
            if (this.buf.length() > 0) {
                return new Text(this.buf.toString(), new Location(this.systemId, this.lineNumber, this.columnNumber));
            }
            return null;
        }
    }

    private static class Parser {
        private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("\\\\(\\$|\\$#|#|#@|\\\\)|(\\s*##)|\\$\\{\\s*([A-Za-z]\\w*)(\\s*:([^\\}]*))?\\s*\\}|\\$#\\{\\s*([A-Za-z][\\.\\w]*)\\s*\\}|(\\s*)#([A-Za-z]\\w*)(\\s*\\(\\s*(.*)\\s*\\))?(\\s*(##.*)?)|(\\s*)#@\\s*([A-Za-z]\\w*)(\\s+(.*?))?(##.*)?$");
        private static final Set<String> KEYWORDS = CollectionUtil.createTreeSet("text", "placeholder", "template", "end");
        private static final int INDEX_OF_ESCAPE = 1;
        private static final int INDEX_OF_COMMENT = 2;
        private static final int INDEX_OF_PLACEHOLDER = 3;
        private static final int INDEX_OF_PLACEHOLDER_PARAMS = 5;
        private static final int INDEX_OF_INCLUDE_TEMPLATE = 6;
        private static final int INDEX_OF_SUBTEMPLATE_PREFIX = 7;
        private static final int INDEX_OF_SUBTEMPLATE = 8;
        private static final int INDEX_OF_IMPORT_FILE = 9;
        private static final int INDEX_OF_IMPORT_FILE_NAME = 10;
        private static final int INDEX_OF_SUBTEMPLATE_SUFFIX = 11;
        private static final int INDEX_OF_PARAM_PREFIX = 13;
        private static final int INDEX_OF_PARAM = 14;
        private static final int INDEX_OF_PARAM_VALUE = 16;
        private final InputSource source;
        private final BufferedReader reader;
        private final String systemId;
        private final ParsingTemplateStack stack = new ParsingTemplateStack();
        private final TextBuffer buf;
        private String currentLine;
        private int lineNumber = 1;

        public Parser(Reader reader, String systemId, InputSource source) {
            this.source = Assert.assertNotNull(source, "input source", new Object[0]);
            this.systemId = StringUtil.trimToNull(systemId);
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.buf = new TextBuffer(systemId);
        }

        public ParsingTemplate parse() {
            this.stack.push(new ParsingTemplate(null, this.systemId, 0, 0, null));
            while (this.nextLine()) {
                Matcher matcher = DIRECTIVE_PATTERN.matcher(this.currentLine);
                int index = 0;
                boolean appendNewLine = true;
                while (matcher.find()) {
                    String name;
                    this.buf.append(this.currentLine, index, matcher.start(), this.lineNumber, index + 1);
                    index = matcher.end();
                    if (matcher.group(1) != null) {
                        this.buf.append(matcher.group(1), this.lineNumber, matcher.start(1));
                        continue;
                    }
                    if (matcher.group(2) != null) {
                        index = this.currentLine.length();
                        if (matcher.start(2) != 0) break;
                        appendNewLine = false;
                        break;
                    }
                    if (matcher.group(14) != null) {
                        this.pushTextNode();
                        name = matcher.group(14);
                        if (matcher.start() > 0) {
                            throw new TemplateParseException("#@" + name + " should start at new line, which is now at " + Location.toString(this.systemId, this.lineNumber, matcher.end(13) + 1));
                        }
                        String value = StringUtil.trimToEmpty(matcher.group(16));
                        this.stack.peek().addParam(name, value, this.lineNumber, matcher.end(13) + 1);
                        appendNewLine = false;
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        this.pushTextNode();
                        name = matcher.group(3);
                        String paramsString = matcher.group(5);
                        Location location = new Location(this.systemId, this.lineNumber, matcher.start() + 1);
                        this.checkName(name, location);
                        this.stack.peek().addNode(new Placeholder(name, paramsString, location));
                        continue;
                    }
                    if (matcher.group(6) != null) {
                        this.pushTextNode();
                        String templateName = matcher.group(6);
                        Location location = new Location(this.systemId, this.lineNumber, matcher.start() + 1);
                        this.stack.peek().addNode(new IncludeTemplate(templateName, location));
                        continue;
                    }
                    if (matcher.group(8) != null) {
                        name = matcher.group(8);
                        if (matcher.start() > 0) {
                            throw new TemplateParseException("#" + name + " should start at new line, which is now at " + Location.toString(this.systemId, this.lineNumber, matcher.end(7) + 1));
                        }
                        if (matcher.end(11) < this.currentLine.length()) {
                            throw new TemplateParseException("Invalid content followed after #" + name + " at " + Location.toString(this.systemId, this.lineNumber, matcher.end(11) + 1));
                        }
                        this.pushTextNode();
                        if ("end".equals(name)) {
                            if (matcher.group(9) != null) {
                                throw new TemplateParseException("Invalid character '(' after #end tag at " + Location.toString(this.systemId, this.lineNumber, matcher.start(9) + matcher.group(9).indexOf("(") + 1));
                            }
                            if (this.stack.size() <= 1) {
                                throw new TemplateParseException("Unmatched #end tag at " + Location.toString(this.systemId, this.lineNumber, matcher.end(7) + 1));
                            }
                            Template subTemplate = this.stack.pop();
                            this.stack.peek().addSubTemplate(subTemplate);
                        } else {
                            int columnNumber = matcher.end(7) + 1;
                            this.checkName(name, new Location(this.systemId, this.lineNumber, columnNumber));
                            if (matcher.group(9) != null) {
                                Template importedTemplate;
                                String importedFileName = StringUtil.trimToNull(StringUtil.trim(StringUtil.trimToEmpty(matcher.group(10)), "\""));
                                int importedFileColumnNumber = matcher.start(10) + 1;
                                if (importedFileName == null) {
                                    throw new TemplateParseException("Import file name is not specified at " + Location.toString(this.systemId, this.lineNumber, importedFileColumnNumber));
                                }
                                InputSource importedSource = null;
                                Exception e = null;
                                try {
                                    importedSource = this.source.getRelative(importedFileName);
                                }
                                catch (Exception ee) {
                                    e = ee;
                                }
                                if (importedSource == null || e != null) {
                                    throw new TemplateParseException("Could not import template file \"" + importedFileName + "\" at " + Location.toString(this.systemId, this.lineNumber, importedFileColumnNumber), e);
                                }
                                try {
                                    importedTemplate = new Template(importedSource, name);
                                }
                                catch (Exception ee) {
                                    throw new TemplateParseException("Could not import template file \"" + importedFileName + "\" at " + Location.toString(this.systemId, this.lineNumber, importedFileColumnNumber), ee);
                                }
                                this.stack.peek().addSubTemplate(importedTemplate);
                            } else {
                                this.stack.push(new ParsingTemplate(name, this.systemId, this.lineNumber, columnNumber, this.stack.peek().params));
                            }
                        }
                        appendNewLine = false;
                        continue;
                    }
                    Assert.unreachableCode();
                }
                this.buf.append(this.currentLine, index, this.currentLine.length(), this.lineNumber, index + 1);
                if (appendNewLine) {
                    this.buf.newLine();
                }
                ++this.lineNumber;
            }
            this.pushTextNode();
            if (this.stack.size() > 1) {
                StringBuilder buf = new StringBuilder("Unclosed tags: ");
                while (this.stack.size() > 1) {
                    buf.append("#").append(this.stack.pop().getName());
                    if (this.stack.size() <= 1) continue;
                    buf.append(", ");
                }
                buf.append(" at ").append(Location.toString(this.systemId, this.lineNumber, 0));
                throw new TemplateParseException(buf.toString());
            }
            Assert.assertTrue(this.stack.size() == 1);
            ParsingTemplate parsingTemplate = this.stack.peek();
            this.postProcessParsingTemplate(parsingTemplate);
            return parsingTemplate;
        }

        private void pushTextNode() {
            Text node = this.buf.toText();
            this.buf.clear();
            if (node != null) {
                this.stack.peek().addNode(node);
            }
        }

        private boolean nextLine() {
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new TemplateParseException("Reading error at " + Location.toString(this.systemId, this.lineNumber, 0), e);
            }
            return this.currentLine != null;
        }

        private void checkName(String name, Object location) {
            if (KEYWORDS.contains(name.toLowerCase())) {
                throw new TemplateParseException("Reserved name: " + name + " at " + location);
            }
        }

        private void postProcessParsingTemplate(ParsingTemplate parsingTemplate) {
            LinkedList<Map<String, Template>> templateStack = CollectionUtil.createLinkedList();
            templateStack.addFirst(parsingTemplate.subtemplates);
            for (Node node : parsingTemplate.nodes) {
                this.postProcessNode(node, templateStack);
            }
            this.chomp(parsingTemplate.nodes);
            this.trimIfNeccessary(parsingTemplate.nodes, parsingTemplate.params);
            this.collapseWhitespacesIfNeccessary(parsingTemplate.nodes, parsingTemplate.params);
            for (Template subTemplate : parsingTemplate.subtemplates.values()) {
                this.postProcessTemplate(subTemplate, templateStack);
            }
            templateStack.removeFirst();
        }

        private void postProcessTemplate(Template template, LinkedList<Map<String, Template>> templateStack) {
            templateStack.addFirst(template.subtemplates);
            for (Node node : template.nodes) {
                this.postProcessNode(node, templateStack);
            }
            LinkedList<Node> nodes = CollectionUtil.createLinkedList(template.nodes);
            this.chomp(nodes);
            this.trimIfNeccessary(nodes, template.params);
            this.collapseWhitespacesIfNeccessary(nodes, template.params);
            template.nodes = nodes.toArray(new Node[nodes.size()]);
            for (Template subTemplate : template.subtemplates.values()) {
                this.postProcessTemplate(subTemplate, templateStack);
            }
            templateStack.removeFirst();
        }

        private void postProcessNode(Node node, LinkedList<Map<String, Template>> templateStack) {
            if (node instanceof IncludeTemplate) {
                ((IncludeTemplate)node).includedTemplate = new Template(this.findTemplate(((IncludeTemplate)node).templateName, templateStack, node.location, "Included"));
            }
            if (node instanceof Placeholder && !ArrayUtil.isEmptyArray(((Placeholder)node).params)) {
                LinkedList<PlaceholderParameter> expandedParameters = CollectionUtil.createLinkedList();
                for (PlaceholderParameter param : ((Placeholder)node).params) {
                    if (param.isTemplateReference()) {
                        String templateName = param.getTemplateName();
                        if (templateName.equals("*") || templateName.endsWith(".*")) {
                            String parentName;
                            Map<String, Template> subtemplates;
                            if (templateName.equals("*")) {
                                subtemplates = templateStack.getFirst();
                                parentName = "";
                            } else {
                                String parentTemplateName = templateName.substring(0, templateName.length() - ".*".length());
                                Template parentTemplate = this.findTemplate(parentTemplateName, templateStack, ((Placeholder)node).location, "Referenced");
                                subtemplates = parentTemplate.subtemplates;
                                parentName = parentTemplateName + ".";
                            }
                            for (Template template : subtemplates.values()) {
                                PlaceholderParameter newParam = new PlaceholderParameter("#" + parentName + template.getName());
                                newParam.templateReference = new Template(template);
                                expandedParameters.add(newParam);
                            }
                            continue;
                        }
                        param.templateReference = new Template(this.findTemplate(templateName, templateStack, ((Placeholder)node).location, "Referenced"));
                        expandedParameters.add(param);
                        continue;
                    }
                    expandedParameters.add(param);
                }
                ((Placeholder)node).params = expandedParameters.toArray(new PlaceholderParameter[expandedParameters.size()]);
            }
        }

        private Template findTemplate(String templateName, LinkedList<Map<String, Template>> templateStack, Location location, String messagePrefix) {
            String[] parts = StringUtil.split(templateName, ".");
            Template template = null;
            if (parts.length >= 1) {
                Map templates;
                Iterator i$ = templateStack.iterator();
                while (i$.hasNext() && (template = (Template)(templates = (Map)i$.next()).get(parts[0])) == null) {
                }
                if (template == null) {
                    template = (Template)predefinedTemplates.get(parts[0]);
                }
                for (int i = 1; i < parts.length && template != null; template = template.getSubTemplate(parts[i]), ++i) {
                }
            }
            if (template == null) {
                throw new TemplateParseException(messagePrefix + " template " + templateName + " is not found in the context around " + location);
            }
            return template;
        }

        private void chomp(LinkedList<Node> nodes) {
            if (!nodes.isEmpty() && nodes.getLast() instanceof Text) {
                Text node = (Text)nodes.getLast();
                String text = node.text;
                if (text.endsWith("\n")) {
                    text = text.substring(0, text.length() - 1);
                }
                if (StringUtil.isEmpty(text)) {
                    nodes.removeLast();
                } else {
                    nodes.set(nodes.size() - 1, new Text(text, node.location));
                }
            }
        }

        private boolean trimIfNeccessary(LinkedList<Node> nodes, Map<String, String> params) {
            String text;
            boolean trimming = this.getBoolean(params.get("trimming"), false, "on", "yes", "true");
            if (!trimming) {
                return false;
            }
            if (!nodes.isEmpty() && nodes.getFirst() instanceof Text) {
                Text firstNode = (Text)nodes.getFirst();
                text = StringUtil.trimStart(firstNode.text);
                if (StringUtil.isEmpty(text)) {
                    nodes.removeFirst();
                } else {
                    nodes.set(0, new Text(text, firstNode.location));
                }
            }
            if (!nodes.isEmpty() && nodes.getLast() instanceof Text) {
                Text lastNode = (Text)nodes.getLast();
                text = StringUtil.trimEnd(lastNode.text);
                if (StringUtil.isEmpty(text)) {
                    nodes.removeLast();
                } else {
                    nodes.set(nodes.size() - 1, new Text(text, lastNode.location));
                }
            }
            boolean startOfLine = true;
            ListIterator<Text> i = nodes.listIterator();
            while (i.hasNext()) {
                boolean endOfLine;
                Node node = (Node)i.next();
                boolean bl = endOfLine = !i.hasNext();
                if (!(node instanceof Text)) {
                    startOfLine = false;
                    continue;
                }
                String text2 = ((Text)node).text;
                StringBuilder buf = new StringBuilder(text2.length());
                int start = 0;
                int pos = text2.indexOf("\n");
                while (pos >= 0 && pos < text2.length()) {
                    String line = text2.substring(start, pos);
                    line = startOfLine ? StringUtil.trim(line) : StringUtil.trimEnd(line);
                    buf.append(line).append("\n");
                    startOfLine = true;
                    start = pos + 1;
                    pos = text2.indexOf("\n", start);
                }
                String line = text2.substring(start);
                if (startOfLine && endOfLine) {
                    line = StringUtil.trim(line);
                } else if (startOfLine) {
                    line = StringUtil.trimStart(line);
                } else if (endOfLine) {
                    line = StringUtil.trimEnd(line);
                }
                buf.append(line);
                i.set(new Text(buf.toString(), node.location));
            }
            return true;
        }

        private boolean collapseWhitespacesIfNeccessary(LinkedList<Node> nodes, Map<String, String> params) {
            boolean collapseWhitespaces = this.getBoolean(params.get("whitespace"), false, "collapse");
            if (!collapseWhitespaces) {
                return false;
            }
            ListIterator<Text> i = nodes.listIterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                if (!(node instanceof Text)) continue;
                char[] cs = ((Text)node).text.toCharArray();
                StringBuilder buf = new StringBuilder(cs.length);
                boolean ws = false;
                boolean newline = false;
                for (char c : cs) {
                    if (c == '\n') {
                        newline = true;
                        continue;
                    }
                    if (Character.isWhitespace(c)) {
                        ws = true;
                        continue;
                    }
                    if (newline) {
                        buf.append('\n');
                    } else if (ws) {
                        buf.append(' ');
                    }
                    ws = false;
                    newline = false;
                    buf.append(c);
                }
                if (newline) {
                    buf.append('\n');
                } else if (ws) {
                    buf.append(' ');
                }
                i.set(new Text(buf.toString(), node.location));
            }
            return true;
        }

        private boolean getBoolean(String value, boolean defaultValue, String ... specificValues) {
            if (!StringUtil.isEmpty(value) && !ArrayUtil.isEmptyArray(specificValues)) {
                for (String specificValue : specificValues) {
                    if (!value.equalsIgnoreCase(specificValue)) continue;
                    return !defaultValue;
                }
            }
            return defaultValue;
        }
    }

    static class Location {
        final String systemId;
        final int lineNumber;
        final int columnNumber;

        public Location(String systemId, int lineNumber, int columnNumber) {
            this.systemId = StringUtil.trimToNull(systemId);
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public String toString() {
            return Location.toString(this.systemId, this.lineNumber, this.columnNumber);
        }

        private static String toString(String systemId, int lineNumber, int columnNumber) {
            StringBuilder buf = new StringBuilder();
            if (systemId == null) {
                buf.append("[unknown source]");
            } else {
                buf.append(systemId);
            }
            if (lineNumber > 0) {
                buf.append(": Line ").append(lineNumber);
                if (columnNumber > 0) {
                    buf.append(" Column ").append(columnNumber);
                }
            }
            return buf.toString();
        }
    }

    static class IncludeTemplate
    extends Node {
        final String templateName;
        Template includedTemplate;

        public IncludeTemplate(String templateName, Location location) {
            super(location);
            this.templateName = Assert.assertNotNull(StringUtil.trimToNull(templateName), "$#{missing template name}", new Object[0]);
        }

        @Override
        public String desc() {
            return "$#{" + this.templateName + "}";
        }

        public String toString() {
            return new ToStringBuilder().format("%s at %s", this.desc(), this.location).toString();
        }
    }

    static class PlaceholderParameter {
        private final String value;
        private Template templateReference;

        public PlaceholderParameter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isTemplateReference() {
            return this.value != null && this.value.length() > 1 && this.value.startsWith("#");
        }

        public String getTemplateName() {
            return this.isTemplateReference() ? this.value.substring(1) : null;
        }

        public Template getTemplateReference() {
            return this.templateReference;
        }

        public String toString() {
            return this.value;
        }
    }

    static class Placeholder
    extends Node {
        private static final PlaceholderParameter[] EMPTY_PARAMS = new PlaceholderParameter[0];
        final String name;
        final String paramsString;
        PlaceholderParameter[] params;

        public Placeholder(String name, String paramsString, Location location) {
            super(location);
            this.name = Assert.assertNotNull(StringUtil.trimToNull(name), "${missing name}", new Object[0]);
            this.paramsString = StringUtil.trimToNull(paramsString);
            this.params = this.splitParams();
        }

        private PlaceholderParameter[] splitParams() {
            if (this.paramsString == null) {
                return EMPTY_PARAMS;
            }
            String[] paramValues = this.paramsString.split(",");
            PlaceholderParameter[] params = new PlaceholderParameter[paramValues.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = new PlaceholderParameter(StringUtil.trimToNull(paramValues[i]));
            }
            return params;
        }

        @Override
        public String desc() {
            if (ArrayUtil.isEmptyArray(this.params)) {
                return "${" + this.name + "}";
            }
            return "${" + this.name + ":" + this.paramsString + "}";
        }

        public String toString() {
            return new ToStringBuilder().format("%s at %s", this.desc(), this.location).toString();
        }
    }

    static class Text
    extends Node {
        final String text;

        public Text(String text, Location location) {
            super(location);
            this.text = Assert.assertNotNull(text, "text is null", new Object[0]);
        }

        @Override
        public String desc() {
            return "text";
        }

        public String toString() {
            String brief = this.text.length() < 10 ? this.text : this.text.substring(0, 10) + "...";
            return String.format("Text with %d characters: %s", this.text.length(), StringEscapeUtil.escapeJava(brief));
        }
    }

    static abstract class Node {
        final Location location;

        public Node(Location location) {
            this.location = Assert.assertNotNull(location, "location", new Object[0]);
        }

        public abstract String desc();
    }
}

