/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal.webpagelite;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.internal.webpagelite.RequestContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestContext
extends RequestContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;

    public ServletRequestContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(ServletUtil.getServletBaseURL(request), ServletUtil.getServletResourcePath(request));
        this.request = Assert.assertNotNull(request, "request is null", new Object[0]);
        this.response = Assert.assertNotNull(response, "response is null", new Object[0]);
        this.servletContext = Assert.assertNotNull(servletContext, "servletContext is null", new Object[0]);
    }

    public ServletRequestContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, String baseURL, String resourceName) {
        super(baseURL, resourceName);
        this.request = Assert.assertNotNull(request, "request is null", new Object[0]);
        this.response = Assert.assertNotNull(response, "response is null", new Object[0]);
        this.servletContext = Assert.assertNotNull(servletContext, "servletContext is null", new Object[0]);
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    protected OutputStream doGetOutputStream(String contentType) throws IOException {
        this.response.setContentType(contentType);
        return this.response.getOutputStream();
    }

    @Override
    protected PrintWriter doGetWriter(String contentType) throws IOException {
        this.response.setContentType(contentType);
        return this.response.getWriter();
    }

    @Override
    public final void redirectTo(String location) throws IOException {
        this.response.sendRedirect(location);
    }

    @Override
    public void resourceNotFound(String resourceName) throws IOException {
        this.response.sendError(404, "Resource Not Found: " + resourceName);
    }

    public static ServletRequestContext getServletRequestContext(RequestContext request) {
        if (request instanceof ServletRequestContext) {
            return (ServletRequestContext)request;
        }
        return null;
    }

    public static void disableCache(RequestContext request) {
        if (ServletRequestContext.getServletRequestContext(request) != null) {
            HttpServletResponse response = ServletRequestContext.getServletRequestContext(request).getResponse();
            response.setHeader("Expires", "Sat, 6 May 1911 12:00:00 GMT");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
        }
    }
}

