/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassLoaderUtil;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InterfaceMaker;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFunctionDelegatorBuilder {
    private static final int PUBLIC_STATIC_MODIFIERS = 9;
    private static final Logger log = LoggerFactory.getLogger(StaticFunctionDelegatorBuilder.class);
    private final Map<Signature, Method> methods = CollectionUtil.createHashMap();
    private ClassLoader classLoader;
    private Class<?> mixinInterface;

    public ClassLoader getClassLoader() {
        return this.classLoader == null ? ClassLoaderUtil.getContextClassLoader() : this.classLoader;
    }

    public StaticFunctionDelegatorBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public StaticFunctionDelegatorBuilder addClass(Class<?> utilClass) {
        for (Method method : utilClass.getMethods()) {
            if (!this.isPublicStatic(method)) continue;
            this.addMethod(method);
        }
        return this;
    }

    public StaticFunctionDelegatorBuilder addMethod(Method method) {
        return this.addMethod(method, null);
    }

    public StaticFunctionDelegatorBuilder addMethod(Method method, String rename) {
        Assert.assertNotNull(method, "Method is null", new Object[0]);
        Assert.assertTrue(this.isPublicStatic(method), "Method is not public static: %s", method);
        Signature sig = this.getSignature(method, rename);
        if (this.methods.containsKey(sig)) {
            throw new IllegalArgumentException("Duplicated method signature: " + sig + "\n  method: " + this.methods.get(sig));
        }
        this.methods.put(sig, method);
        return this;
    }

    private Signature getSignature(Method method, String rename) {
        String name = ObjectUtil.defaultIfNull(StringUtil.trimToNull(rename), method.getName());
        Type returnType = Type.getType(method.getReturnType());
        Type[] paramTypes = Type.getArgumentTypes((Method)method);
        return new Signature(name, returnType, paramTypes);
    }

    private boolean isPublicStatic(Method method) {
        return (method.getModifiers() & 9) == 9;
    }

    private boolean isEqualsMethod(Method method) {
        if (!"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    private boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    public Class<?> getMixinInterface() {
        if (this.mixinInterface == null) {
            InterfaceMaker im = new InterfaceMaker();
            for (Map.Entry<Signature, Method> entry : this.methods.entrySet()) {
                Signature sig = entry.getKey();
                Method method = entry.getValue();
                Type[] exceptionTypes = new Type[method.getExceptionTypes().length];
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    exceptionTypes[i] = Type.getType(method.getExceptionTypes()[i]);
                }
                im.add(sig, exceptionTypes);
            }
            im.setClassLoader(this.getClassLoader());
            im.setNamingPolicy((NamingPolicy)new DefaultNamingPolicy(){

                public String getClassName(String prefix, String source, Object key, Predicate names) {
                    return super.getClassName("", ClassUtil.getSimpleClassName(StaticFunctionDelegatorBuilder.class), key, names);
                }
            });
            this.mixinInterface = im.create();
        }
        return this.mixinInterface;
    }

    public Object toObject() {
        final Class<?> intfs = this.getMixinInterface();
        final Map<Method, FastMethod> methodMappings = this.getMethodMappings(intfs);
        Enhancer generator = new Enhancer();
        generator.setClassLoader(this.getClassLoader());
        generator.setSuperclass(Object.class);
        generator.setInterfaces(new Class[]{intfs});
        generator.setCallbacks(new Callback[]{new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return proxy.invokeSuper(obj, args);
            }
        }, new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true);
                for (Map.Entry entry : methodMappings.entrySet()) {
                    mb.append(((Method)entry.getKey()).getName(), ClassUtil.getSimpleMethodSignature(((FastMethod)entry.getValue()).getJavaMethod(), false, true, true, false));
                }
                return new ToStringBuilder().append(intfs.getName()).append(mb).toString();
            }
        }, new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                FastMethod realMethod = (FastMethod)Assert.assertNotNull(methodMappings.get(method), "unknown method: %s", method);
                return realMethod.invoke(null, args);
            }
        }});
        generator.setCallbackFilter(new CallbackFilter(){

            public int accept(Method method) {
                if (StaticFunctionDelegatorBuilder.this.isEqualsMethod(method) || StaticFunctionDelegatorBuilder.this.isHashCodeMethod(method)) {
                    return 0;
                }
                if (StaticFunctionDelegatorBuilder.this.isToStringMethod(method)) {
                    return 1;
                }
                return 2;
            }
        });
        Object obj = generator.create();
        log.debug("Generated mixin function delegator: {}", obj);
        return obj;
    }

    private Map<Method, FastMethod> getMethodMappings(Class<?> intfs) {
        HashMap<Method, FastMethod> methodMappings = CollectionUtil.createHashMap();
        for (Method method : intfs.getMethods()) {
            Signature sig = this.getSignature(method, null);
            Method realMethod = Assert.assertNotNull(this.methods.get(sig), "unknown method signature: %s", sig);
            FastClass fc = FastClass.create((ClassLoader)this.getClassLoader(), realMethod.getDeclaringClass());
            FastMethod fm = fc.getMethod(realMethod);
            methodMappings.put(method, fm);
        }
        return methodMappings;
    }
}

