/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.i18n;

import com.alibaba.citrus.util.i18n.CharConverter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CharConvertReader
extends FilterReader {
    private CharConverter converter;

    public CharConvertReader(Reader in, String converterName) {
        this(in, CharConverter.getInstance(converterName));
    }

    public CharConvertReader(Reader in, CharConverter converter) {
        super(in);
        this.converter = converter;
        if (converter == null) {
            throw new NullPointerException("converter is null");
        }
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch < 0) {
            return ch;
        }
        return this.converter.convert((char)ch);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = super.read(cbuf, off, len);
        if (count > 0) {
            this.converter.convert(cbuf, off, count);
        }
        return count;
    }
}

