/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.web.HttpRequestHandler;
import org.w3c.dom.Element;

public class RequestHandlerValve
extends AbstractValve {
    @Autowired
    private HttpServletRequest request;
    private final HttpRequestHandler handler;

    public RequestHandlerValve(HttpRequestHandler handler) {
        this.handler = Assert.assertNotNull(handler, "handler", new Object[0]);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        this.handler.handleRequest(rundata.getRequest(), rundata.getResponse());
        pipelineContext.invokeNext();
    }

    public static class DefinitonParser
    extends AbstractValveDefinitionParser<RequestHandlerValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Object handler = SpringExtUtil.parseBean(element, parserContext, builder);
            builder.addConstructorArgValue(handler);
        }
    }
}

