/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.logconfig.support.SecurityLogger;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.CsrfToken;
import com.alibaba.citrus.turbine.util.CsrfTokenCheckException;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CheckCsrfTokenValve
extends AbstractValve {
    private final SecurityLogger log = new SecurityLogger();
    @Autowired
    private HttpServletRequest request;
    private String tokenKey;
    private int maxTokens;
    private String expiredPage;

    public String getTokenKey() {
        return this.tokenKey;
    }

    public void setTokenKey(String tokenKey) {
        this.tokenKey = StringUtil.trimToNull(tokenKey);
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
    }

    public String getExpiredPage() {
        return this.expiredPage;
    }

    public void setExpiredPage(String expiredPage) {
        this.expiredPage = expiredPage;
    }

    public String getLogName() {
        return this.log.getLogger().getName();
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    @Override
    protected void init() {
        this.tokenKey = ObjectUtil.defaultIfNull(this.tokenKey, "_csrf_token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        HttpSession session;
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        String tokenFromRequest = StringUtil.trimToNull(rundata.getParameters().getString(this.tokenKey));
        if (tokenFromRequest != null && !tokenFromRequest.equals(CsrfToken.getLongLiveTokenInSession(session = rundata.getRequest().getSession()))) {
            LinkedList<String> tokensInSession = CsrfToken.getTokensInSession(session, this.tokenKey);
            if (!tokensInSession.contains(tokenFromRequest)) {
                this.requestExpired(rundata, tokenFromRequest, tokensInSession);
            } else {
                tokensInSession.remove(tokenFromRequest);
                CsrfToken.setTokensInSession(session, this.tokenKey, tokensInSession);
            }
        }
        try {
            CsrfToken.setContextTokenConfiguration(this.tokenKey, this.maxTokens);
            pipelineContext.invokeNext();
        }
        finally {
            CsrfToken.resetContextTokenConfiguration();
        }
    }

    private void requestExpired(TurbineRunData rundata, String tokenFromRequest, List<String> tokensInSession) {
        this.log.getLogger().warn("CsrfToken \"{}\" does not match: requested token is {}, but the session tokens are {}.", new Object[]{this.tokenKey, tokenFromRequest, tokensInSession});
        if (this.expiredPage != null) {
            rundata.setRedirectTarget(this.expiredPage);
        } else if (this.expiredPage == null) {
            throw new CsrfTokenCheckException(rundata.getRequest().getRequestURL().toString());
        }
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<CheckCsrfTokenValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "tokenKey", "maxTokens", "expiredPage", "logName");
        }
    }
}

