/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.condition;

import com.alibaba.citrus.service.pipeline.PipelineStates;
import com.alibaba.citrus.service.pipeline.support.AbstractConditionDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.pipeline.condition.AbstractTurbineCondition;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PathCondition
extends AbstractTurbineCondition {
    public static final String DEFAULT_VAR = "subst";
    private Pattern[] patterns;
    private String[] patternStrings;
    private String var;

    public void setName(String patterns) {
        if (patterns != null) {
            this.patternStrings = StringUtil.split(patterns, ", ");
            this.patterns = new Pattern[this.patternStrings.length];
            for (int i = 0; i < this.patternStrings.length; ++i) {
                this.patterns[i] = Pattern.compile(this.patternStrings[i]);
            }
        }
    }

    public void setVar(String var) {
        this.var = StringUtil.trimToNull(var);
    }

    @Override
    public final boolean isSatisfied(PipelineStates states) {
        String path = FileUtil.normalizeAbsolutePath(this.getPath());
        for (int i = 0; i < this.patterns.length; ++i) {
            Matcher matcher = this.patterns[i].matcher(path);
            if (!matcher.find()) continue;
            this.log(this.patternStrings[i]);
            String var = ObjectUtil.defaultIfNull(this.var, DEFAULT_VAR);
            MatchResultSubstitution subst = new MatchResultSubstitution(matcher);
            states.setAttribute(var, subst);
            return true;
        }
        return false;
    }

    protected String getPath() {
        return ServletUtil.getResourcePath(this.getRunData().getRequest());
    }

    protected void log(String patternString) {
        this.log.debug("URL path(servletPath/pathInfo) matched pattern: {}", (Object)patternString);
    }

    protected static abstract class AbstractPathConditionDefinitionParser<T extends PathCondition>
    extends AbstractConditionDefinitionParser<T> {
        protected AbstractPathConditionDefinitionParser() {
        }

        @Override
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "name", "var");
        }
    }

    public static class DefinitionParser
    extends AbstractPathConditionDefinitionParser<PathCondition> {
    }
}

