/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.dataresolver.impl;

import com.alibaba.citrus.service.dataresolver.DataResolverContext;
import com.alibaba.citrus.service.dataresolver.DataResolverException;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;

public class DataResolverUtil {
    static <A extends Annotation> String getAnnotationNameOrValue(Class<A> annotationType, A annotation, DataResolverContext context, boolean hasOptionalArgs) {
        String name = StringUtil.trimToNull(DataResolverUtil.get(annotationType, annotation, "name"));
        if (name == null) {
            name = StringUtil.trimToNull(DataResolverUtil.get(annotationType, annotation, "value"));
            String typeName = annotationType.getSimpleName();
            Assert.assertNotNull(name, "missing @%s's name: %s", typeName, context);
            Assert.assertTrue(!hasOptionalArgs, "use @%s(name=\"%s\") instead of @%s(value=\"%s\"): %s", typeName, name, typeName, name, context);
        }
        return name;
    }

    private static <A extends Annotation> String get(Class<A> annotationType, A annotation, String name) {
        try {
            return (String)annotation.getClass().getMethod(name, new Class[0]).invoke(annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("could not get value: @%s.%s()", annotationType.getSimpleName(), name), e);
        }
    }

    static FastConstructor getFastConstructor(Class<?> beanType) {
        Constructor<?> constructor;
        int mod = beanType.getModifiers();
        Assert.assertTrue(!Modifier.isAbstract(mod) && Modifier.isPublic(mod), "Class to set properties should be public and concrete: %s", beanType.getName());
        try {
            constructor = beanType.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Class to set properties has no default constructor: %s", beanType.getName()));
        }
        return FastClass.create(beanType).getConstructor(constructor);
    }

    static Object newInstance(FastConstructor fc) {
        try {
            return Assert.assertNotNull(fc, "fastConstructor==null", new Object[0]).newInstance();
        }
        catch (InvocationTargetException e) {
            throw new DataResolverException("Failed to create instance of class " + fc.getDeclaringClass().getName(), e.getCause());
        }
    }
}

