/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.auth.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.turbine.auth.PageAuthorizationService;
import com.alibaba.citrus.turbine.auth.impl.AuthGrant;
import com.alibaba.citrus.turbine.auth.impl.AuthMatch;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;

public class PageAuthorizationServiceImpl
extends AbstractService<PageAuthorizationService>
implements PageAuthorizationService {
    private final List<AuthMatch> matches = CollectionUtil.createLinkedList();
    private boolean allowByDefault = false;

    public void setMatches(AuthMatch[] matches) {
        this.matches.clear();
        if (matches != null) {
            for (AuthMatch match : matches) {
                this.matches.add(match);
            }
        }
    }

    public boolean isAllowByDefault() {
        return this.allowByDefault;
    }

    public void setAllowByDefault(boolean allowByDefault) {
        this.allowByDefault = allowByDefault;
    }

    @Override
    public boolean isAllow(String target, String userName, String[] roleNames, String ... actions) {
        PageAuthorizationResult result = this.authorize(target, userName, roleNames, actions);
        switch (result) {
            case ALLOWED: {
                return true;
            }
            case DENIED: {
                return false;
            }
        }
        return this.allowByDefault;
    }

    public PageAuthorizationResult authorize(String target, String userName, String[] roleNames, String ... actions) {
        PageAuthorizationResult result;
        MatchResult[] results;
        userName = StringUtil.trimToNull(userName);
        if (actions == null) {
            actions = new String[]{""};
        }
        if (roleNames == null) {
            roleNames = BasicConstant.EMPTY_STRING_ARRAY;
        }
        if (ArrayUtil.isEmptyArray(results = this.getMatchResults(target))) {
            result = PageAuthorizationResult.TARGET_NOT_MATCH;
        } else {
            boolean grantNotMatch = false;
            for (int i = 0; i < actions.length; ++i) {
                actions[i] = StringUtil.trimToEmpty(actions[i]);
                Boolean actionAllowed = this.isActionAllowed(results, target, userName, roleNames, actions[i]);
                if (actionAllowed == null) {
                    grantNotMatch = true;
                    continue;
                }
                if (actionAllowed.booleanValue()) continue;
                return PageAuthorizationResult.DENIED;
            }
            if (!grantNotMatch) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Access Permitted: target=\"{}\", user=\"{}\", roles={}, action={}", new Object[]{target, userName, ObjectUtil.toString(roleNames), ObjectUtil.toString(actions)});
                }
                return PageAuthorizationResult.ALLOWED;
            }
            result = PageAuthorizationResult.GRANT_NOT_MATCH;
        }
        if (this.allowByDefault) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Access Permitted.  No matches found for request: target=\"{}\", user=\"{}\", roles={}, action={}", new Object[]{target, userName, ObjectUtil.toString(roleNames), ObjectUtil.toString(actions)});
            }
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Access Denied.  No matches found for request: target=\"{}\", user=\"{}\", roles={}, action={}", new Object[]{target, userName, ObjectUtil.toString(roleNames), ObjectUtil.toString(actions)});
        }
        return result;
    }

    private Boolean isActionAllowed(MatchResult[] results, String target, String userName, String[] roleNames, String action) {
        for (MatchResult result : results) {
            AuthMatch match = result.match;
            for (int i = match.getGrants().length - 1; i >= 0; --i) {
                boolean allowed;
                AuthGrant grant = match.getGrants()[i];
                boolean userMatch = grant.isUserMatched(userName);
                boolean roleMatch = grant.areRolesMatched(roleNames);
                if (!userMatch && !roleMatch) continue;
                boolean actionAllowed = grant.isActionAllowed(action);
                boolean actionDenied = grant.isActionDenied(action);
                if (!actionAllowed && !actionDenied) continue;
                boolean bl = allowed = !actionDenied;
                if (allowed) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("Access Partially Permitted: target=\"{}\", user=\"{}\", roles={}, action=\"{}\"\n{}", new Object[]{target, userName, ObjectUtil.toString(roleNames), action, match.toString(i)});
                    }
                    return Boolean.TRUE;
                }
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Access Denied: target=\"{}\", user=\"{}\", roles={}, action=\"{}\"\n{}", new Object[]{target, userName, ObjectUtil.toString(roleNames), action, match.toString(i)});
                }
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private MatchResult[] getMatchResults(String target) {
        ArrayList<MatchResult> results = CollectionUtil.createArrayList(this.matches.size());
        ListIterator<AuthMatch> i = this.matches.listIterator(this.matches.size());
        while (i.hasPrevious()) {
            AuthMatch match = i.previous();
            Matcher matcher = match.getPattern().matcher(target);
            if (!matcher.find()) continue;
            MatchResult result = new MatchResult();
            result.matchLength = matcher.end() - matcher.start();
            result.match = match;
            result.target = target;
            results.add(result);
        }
        Collections.sort(results);
        LinkedHashMap<AuthGrant[], MatchResult> grantsSet = CollectionUtil.createLinkedHashMap();
        for (MatchResult result : results) {
            AuthGrant[] grants = result.match.getGrants();
            if (grantsSet.containsKey(grants)) continue;
            grantsSet.put(grants, result);
        }
        return grantsSet.values().toArray(new MatchResult[grantsSet.size()]);
    }

    public static enum PageAuthorizationResult {
        ALLOWED,
        DENIED,
        TARGET_NOT_MATCH,
        GRANT_NOT_MATCH;

    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private int matchLength = -1;
        private AuthMatch match;
        private String target;

        private MatchResult() {
        }

        @Override
        public int compareTo(MatchResult o) {
            return o.matchLength - this.matchLength;
        }

        public String toString() {
            return "Match length=" + this.matchLength + ", target=" + this.target + ", " + this.match;
        }
    }
}

