/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.resolver;

import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.support.SchemaSet;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaEntityResolver
implements EntityResolver {
    private static final Logger log = LoggerFactory.getLogger(SchemaEntityResolver.class);
    private final EntityResolver defaultEntityResolver;
    private final SchemaSet schemas;

    public SchemaEntityResolver(EntityResolver defaultEntityResolver, Schemas ... schemasList) {
        this.defaultEntityResolver = defaultEntityResolver;
        this.schemas = new SchemaSet(schemasList);
    }

    public EntityResolver getDefaultEntityResolver() {
        return this.defaultEntityResolver;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        log.trace("Trying to locate XML entity {} as configuration points schema.", (Object)systemId);
        Schema schema = this.schemas.findSchema(systemId);
        if (schema == null) {
            if (this.defaultEntityResolver != null) {
                return this.defaultEntityResolver.resolveEntity(publicId, systemId);
            }
            return null;
        }
        log.debug("Found XML schema for systemId {}: {}", (Object)systemId, (Object)schema);
        return new InputSource(schema.getInputStream());
    }
}

