/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.context;

import com.alibaba.citrus.springext.util.ProxyTargetFactory;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

class InheritableListableBeanFactory
extends DefaultListableBeanFactory {
    private final Map<Class<?>, Object> parentResolvableDependencies;

    InheritableListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
        Map<Class<?>, Object> resolvableDependencies = this.getResolvableDependencies((BeanFactory)this);
        Map<Class<?>, Object> parentResolvableDependencies = this.getResolvableDependencies(parentBeanFactory);
        if (parentResolvableDependencies != null) {
            if (resolvableDependencies != null) {
                resolvableDependencies.putAll(parentResolvableDependencies);
            }
            this.parentResolvableDependencies = Collections.unmodifiableMap(parentResolvableDependencies);
        } else {
            this.parentResolvableDependencies = null;
        }
    }

    private Map<Class<?>, Object> getResolvableDependencies(BeanFactory parentBeanFactory) {
        if (parentBeanFactory instanceof DefaultListableBeanFactory) {
            try {
                Field field = DefaultListableBeanFactory.class.getDeclaredField("resolvableDependencies");
                field.setAccessible(true);
                return (Map)field.get(parentBeanFactory);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to get value of DefaultListableBeanFactory.resolvableDependencies, autowiring of singleton proxy may function wrong", (Throwable)e);
            }
        }
        return null;
    }

    public void registerResolvableDependency(Class dependencyType, Object autowiredValue) {
        if (this.parentResolvableDependencies == null || !(this.parentResolvableDependencies.get(dependencyType) instanceof ProxyTargetFactory)) {
            super.registerResolvableDependency(dependencyType, autowiredValue);
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        BeanDefinition existingBd;
        try {
            existingBd = this.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            existingBd = null;
        }
        if (existingBd != null && existingBd instanceof AbstractBeanDefinition) {
            ((AbstractBeanDefinition)existingBd).overrideFrom(bd);
            super.registerBeanDefinition(beanName, existingBd);
        } else {
            super.registerBeanDefinition(beanName, bd);
        }
    }
}

