/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionType;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.VersionableSchemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointSettings;
import com.alibaba.citrus.springext.impl.ContributionKey;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.springext.impl.VersionableSchemasImpl;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;

public class ContributionImpl
implements Contribution {
    private static final Logger log = LoggerFactory.getLogger(Contribution.class);
    private final ConfigurationPoint configurationPoint;
    private final ConfigurationPointSettings settings;
    private final ContributionKey key;
    private final String implementationClassName;
    private VersionableSchemas schemas;

    ContributionImpl(ConfigurationPointImpl cp, ConfigurationPointSettings settings, ContributionType type, String name, String contributionClassName) {
        this.configurationPoint = Assert.assertNotNull(cp, "configurationPoint", new Object[0]);
        this.settings = settings;
        this.key = new ContributionKey(name, type);
        this.implementationClassName = contributionClassName;
    }

    @Override
    public ConfigurationPoint getConfigurationPoint() {
        return this.configurationPoint;
    }

    @Override
    public ContributionType getType() {
        return this.key.getType();
    }

    @Override
    public String getName() {
        return this.key.getName();
    }

    ContributionKey getKey() {
        return this.key;
    }

    @Override
    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    @Override
    public VersionableSchemas getSchemas() {
        if (this.schemas == null) {
            String mainName = this.configurationPoint.getName() + "/" + this.getName();
            Schema mainSchema = this.loadMainSchema(mainName);
            Schema[] versionedSchemas = this.loadVersionedSchemas(mainName);
            this.schemas = new VersionableSchemasImpl(mainSchema, versionedSchemas);
        }
        return this.schemas;
    }

    private Schema loadMainSchema(String mainName) {
        URL resource;
        String schemaName = mainName + "." + "xsd";
        try {
            resource = this.settings.getResource(schemaName, log);
            Assert.assertNotNull(resource, schemaName, new Object[0]);
            log.debug("Found schema file for contribution {}: {}", (Object)mainName, (Object)resource);
        }
        catch (IOException e) {
            log.warn("Failed to load schema: {}:  {}", (Object)schemaName, (Object)e);
            resource = null;
        }
        if (resource == null) {
            return null;
        }
        return new SchemaImpl(schemaName, null, this.getDescription(), new ContributionSchemaSource(resource, this.getConfigurationPoint().getConfigurationPoints(), this.getConfigurationPoint()));
    }

    private Schema[] loadVersionedSchemas(String mainName) {
        List<URL> resources;
        String schemaNamePattern = mainName + "-*." + "xsd";
        Pattern pattern = Pattern.compile("^.*(" + mainName + "-(.+)\\." + "xsd" + ")$");
        try {
            resources = this.settings.getResources(schemaNamePattern, log);
        }
        catch (IOException e) {
            log.warn("Failed to load schemas: {}:  {}", (Object)schemaNamePattern, (Object)e);
            resources = Collections.emptyList();
        }
        Assert.assertNotNull(resources, schemaNamePattern, new Object[0]);
        LinkedList<Schema> schemas = CollectionUtil.createLinkedList();
        Iterator<URL> i = resources.iterator();
        while (i.hasNext()) {
            URL url = i.next();
            String path = url.getPath();
            Matcher matcher = pattern.matcher(path);
            if (matcher.matches()) {
                String schemaName = matcher.group(1);
                String schemaVersion = matcher.group(2);
                if (this.checkVersion(schemaVersion)) {
                    schemas.add(new SchemaImpl(schemaName, schemaVersion, this.getDescription(), new ContributionSchemaSource(url, this.getConfigurationPoint().getConfigurationPoints(), this.getConfigurationPoint())));
                    continue;
                }
                i.remove();
                continue;
            }
            throw new ConfigurationPointException("Invalid schema name: " + url);
        }
        if (!resources.isEmpty() && log.isDebugEnabled()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Found %d versioned schema files for contribution %s:", resources.size(), mainName);
            buf.append(resources);
            log.debug(buf.toString());
        }
        return schemas.toArray(new Schema[schemas.size()]);
    }

    private boolean checkVersion(String schemaVersion) {
        String name = this.getName();
        for (String v : schemaVersion.split("-")) {
            name = name + "-" + v;
            for (ContributionType type : ContributionType.values()) {
                if (this.getConfigurationPoint().getContribution(name, type) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getDescription() {
        return String.format("Contribution[%s:%s]", this.getConfigurationPoint().getName(), this.getName());
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("Contribution[toConfigurationPoint=%s, name=%s, type=%s, class=%s]", new Object[]{this.getConfigurationPoint().getName(), this.getName(), this.getType(), this.implementationClassName}).start();
        buf.append(this.getSchemas());
        return buf.end().toString();
    }

    private static class ContributionSchemaSource
    implements InputStreamSource {
        private final URL url;
        private final ConfigurationPoints cps;
        private final ConfigurationPoint thisCp;

        public ContributionSchemaSource(URL url, ConfigurationPoints cps, ConfigurationPoint thisCp) {
            this.url = Assert.assertNotNull(url, "no schema URL", new Object[0]);
            this.cps = Assert.assertNotNull(cps, "no ConfigurationPoints", new Object[0]);
            this.thisCp = Assert.assertNotNull(thisCp, "this ConfigurationPoint", new Object[0]);
        }

        public InputStream getInputStream() throws IOException {
            try {
                return new ByteArrayInputStream(SchemaUtil.getContributionSchemaContent(this.getOriginalInputStream(), this.url.toExternalForm(), true, this.cps, this.thisCp));
            }
            catch (DocumentException e) {
                return this.getOriginalInputStream();
            }
        }

        private InputStream getOriginalInputStream() throws IOException {
            URLConnection connection = this.url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }

        public String toString() {
            return this.url.toExternalForm();
        }
    }
}

