/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.impl.ConfigurationPointImpl;
import com.alibaba.citrus.springext.impl.ConfigurationPointSettings;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ConfigurationPointsImpl
implements ConfigurationPoints {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPoints.class);
    private static final String NAMESPACE_URI_KEY = "namespaceUri";
    private static final String DEFAULT_ELEMENT_KEY = "defaultElement";
    private static final String PREFERRED_NS_PREFIX = "nsPrefix";
    private final ConfigurationPointSettings settings;
    private final String configurationPointsLocation;
    private final Map<String, ConfigurationPoint> namespaceUriToConfigurationPoints;
    private final Map<String, ConfigurationPoint> nameToConfigurationPoints;
    private final Collection<ConfigurationPoint> configurationPoints;
    private boolean initialized;

    public ConfigurationPointsImpl() {
        this(null, null);
    }

    public ConfigurationPointsImpl(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public ConfigurationPointsImpl(ClassLoader classLoader, String configurationPointsLocation) {
        this.configurationPointsLocation = StringUtil.defaultIfEmpty(configurationPointsLocation, "META-INF/spring.configuration-points");
        this.settings = new ConfigurationPointSettings(classLoader, this.configurationPointsLocation);
        this.namespaceUriToConfigurationPoints = CollectionUtil.createHashMap();
        this.nameToConfigurationPoints = CollectionUtil.createTreeMap();
        this.configurationPoints = Collections.unmodifiableCollection(this.nameToConfigurationPoints.values());
    }

    private void ensureInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.loadConfigurationPoints();
    }

    private void loadConfigurationPoints() {
        Properties mappings;
        log.trace("Trying to load configuration points at {}", (Object)this.configurationPointsLocation);
        try {
            mappings = PropertiesLoaderUtils.loadAllProperties((String)this.configurationPointsLocation, (ClassLoader)this.settings.classLoader);
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Unable to load Configuration Points from " + this.configurationPointsLocation, e);
        }
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            String name = this.normalizeConfigurationPointName((String)entry.getKey());
            Map<String, String> params = this.parseNamespaceUriAndParams((String)entry.getValue());
            String namespaceUri = Assert.assertNotNull(params.get(NAMESPACE_URI_KEY), NAMESPACE_URI_KEY, new Object[0]);
            if (!namespaceUri.endsWith(name)) {
                throw new ConfigurationPointException("Naming Convention Violation: namespace URI [" + namespaceUri + "] of configuration point should end with its name [" + name + "].  This configuration point is located at " + this.configurationPointsLocation + ".");
            }
            String defaultElementName = params.get(DEFAULT_ELEMENT_KEY);
            String preferredNsPrefix = params.get(PREFERRED_NS_PREFIX);
            ConfigurationPointImpl cp = new ConfigurationPointImpl(this, this.settings, name, namespaceUri, defaultElementName, preferredNsPrefix);
            this.namespaceUriToConfigurationPoints.put(namespaceUri, cp);
            this.nameToConfigurationPoints.put(name, cp);
        }
        if (log.isDebugEnabled()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Loaded configuration points at %s, %d configuration points found.", this.configurationPointsLocation, this.nameToConfigurationPoints.size());
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true);
            for (String name : this.nameToConfigurationPoints.keySet()) {
                mb.append(name, this.nameToConfigurationPoints.get(name).getNamespaceUri());
            }
            mb.appendTo(buf);
            log.debug(buf.toString());
        }
    }

    @Override
    public Collection<ConfigurationPoint> getConfigurationPoints() {
        this.ensureInit();
        return this.configurationPoints;
    }

    @Override
    public ConfigurationPoint getConfigurationPointByName(String name) {
        this.ensureInit();
        return this.ensureInitConfigurationPoint((ConfigurationPointImpl)this.nameToConfigurationPoints.get(this.normalizeConfigurationPointName(name)));
    }

    @Override
    public ConfigurationPoint getConfigurationPointByNamespaceUri(String namespaceUri) {
        this.ensureInit();
        return this.ensureInitConfigurationPoint((ConfigurationPointImpl)this.namespaceUriToConfigurationPoints.get(this.normalizeNamespaceUri(namespaceUri)));
    }

    private ConfigurationPoint ensureInitConfigurationPoint(ConfigurationPointImpl cp) {
        if (cp != null) {
            cp.init();
        }
        return cp;
    }

    private String normalizeConfigurationPointName(String name) {
        return StringUtil.trimToNull(FileUtil.normalizeRelativePath(name, true));
    }

    private String normalizeNamespaceUri(String uri) {
        if ((uri = StringUtil.trimToNull(uri)) != null) {
            uri = URI.create(uri).normalize().toString().replaceAll("/$", "");
        }
        return uri;
    }

    private Map<String, String> parseNamespaceUriAndParams(String uriAndParams) {
        String[] parts;
        if ((uriAndParams = StringUtil.trimToNull(uriAndParams)) == null) {
            return null;
        }
        HashMap<String, String> params = CollectionUtil.createHashMap(4);
        for (String part : parts = uriAndParams.split(",|;")) {
            if ((part = StringUtil.trimToNull(part)) == null) continue;
            int index = part.indexOf("=");
            if (index >= 0) {
                String paramKey = StringUtil.trimToNull(part.substring(0, index));
                String paramValue = StringUtil.trimToNull(part.substring(index + 1));
                if (paramKey == null) {
                    throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
                }
                params.put(paramKey, paramValue);
                continue;
            }
            if (params.containsKey(NAMESPACE_URI_KEY)) {
                throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
            }
            params.put(NAMESPACE_URI_KEY, this.normalizeNamespaceUri(part));
        }
        if (!params.containsKey(NAMESPACE_URI_KEY)) {
            throw new IllegalArgumentException("Illegal namespace URI: " + uriAndParams);
        }
        return params;
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        TreeMap<String, Schema> mappings = CollectionUtil.createTreeMap();
        for (ConfigurationPoint cp : this.getConfigurationPoints()) {
            mappings.putAll(cp.getSchemas().getNamedMappings());
            for (Contribution contrib : cp.getContributions()) {
                mappings.putAll(contrib.getSchemas().getNamedMappings());
            }
        }
        return mappings;
    }

    public String toString() {
        if (!this.initialized) {
            return "ConfigurationPoints[uninitialized]";
        }
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("ConfigurationPoints[%d cps, loaded from %s]", this.configurationPoints.size(), this.configurationPointsLocation);
        if (!this.configurationPoints.isEmpty()) {
            buf.appendCollection(this.configurationPoints);
        }
        return buf.toString();
    }
}

