/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;

final class ConfigurationPointSettings {
    public final ClassLoader classLoader;
    public final String baseLocation;
    private final ResourcePatternResolver resolver;

    ConfigurationPointSettings(ClassLoader classLoader, String configurationPointsLocation) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        Assert.assertNotNull(configurationPointsLocation, "configurationPointsLocation", new Object[0]);
        this.classLoader = classLoader;
        this.baseLocation = configurationPointsLocation.substring(0, configurationPointsLocation.lastIndexOf("/") + 1);
        this.resolver = new PathMatchingResourcePatternResolver(classLoader);
    }

    URL getResource(String relativeLocation, Logger log) throws IOException {
        Resource resource;
        String location = this.toAbsoluteLocation(relativeLocation);
        if (log != null) {
            log.trace("Trying to find resource at {}", (Object)location);
        }
        if ((resource = this.resolver.getResource(location)) != null) {
            return resource.getURL();
        }
        return null;
    }

    List<URL> getResources(String relativeLocationPattern, Logger log) throws IOException {
        List<URL> urls;
        Resource[] resources;
        String locationPattern = this.toAbsoluteLocation(relativeLocationPattern);
        if (log != null) {
            log.trace("Trying to find resources at {}", (Object)locationPattern);
        }
        if ((resources = this.resolver.getResources(locationPattern)) == null) {
            urls = Collections.emptyList();
        } else {
            urls = CollectionUtil.createLinkedList();
            for (Resource resource : resources) {
                urls.add(resource.getURL());
            }
        }
        return urls;
    }

    private String toAbsoluteLocation(String relativeLocationPattern) {
        if ((relativeLocationPattern = Assert.assertNotNull(StringUtil.trimToNull(relativeLocationPattern), "locationPattern", new Object[0])).startsWith("classpath:")) {
            relativeLocationPattern = relativeLocationPattern.substring("classpath:".length());
        }
        return "classpath:" + this.baseLocation + relativeLocationPattern;
    }
}

