/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.export;

import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.export.SchemaExporter;
import com.alibaba.citrus.util.internal.webpagelite.RequestContext;
import com.alibaba.citrus.util.internal.webpagelite.RequestProcessor;
import com.alibaba.citrus.util.templatelite.FallbackTextWriter;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.util.templatelite.TextWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class SchemaExporterWEB
extends SchemaExporter {
    private final Template listTemplate = new Template(this.getClass().getResource("list.htm"));
    private final RequestProcessor<RequestContext> processor = new RequestProcessor<RequestContext>(){

        @Override
        protected boolean resourceExists(String resourceName) {
            return SchemaExporterWEB.this.getEntry(resourceName) != null;
        }

        @Override
        protected void renderPage(RequestContext request, String resourceName) throws IOException {
            SchemaExporter.Entry entry = SchemaExporterWEB.this.getEntry(resourceName);
            if (entry.isDirectory()) {
                SchemaExporterWEB.this.renderListPage(request, entry);
            } else {
                SchemaExporterWEB.this.renderContentPage(request, entry);
            }
        }
    };
    private final MenuProvider menuProvider;

    public SchemaExporterWEB() {
        this((MenuProvider)null);
    }

    public SchemaExporterWEB(MenuProvider menuProvider) {
        this.menuProvider = menuProvider;
    }

    public MenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public void processRequest(RequestContext request) throws IOException {
        this.processor.processRequest(request);
    }

    private void renderListPage(RequestContext request, SchemaExporter.Entry rootEntry) throws IOException {
        PrintWriter out = request.getWriter("text/html; charset=UTF-8");
        this.listTemplate.accept(new ListPageVisitor(out, request, rootEntry, "text/html; charset=UTF-8"));
        out.flush();
    }

    private void renderContentPage(RequestContext request, SchemaExporter.Entry entry) throws IOException {
        PrintWriter out = request.getWriter("text/xml; charset=UTF-8");
        this.writeTo(out, entry, "UTF-8", request.getResourceURL("/"));
        out.flush();
    }

    private class FileEntryVisitor
    extends AbstractEntryVisitor {
        private final Schema schema;
        private final String namespace;

        public FileEntryVisitor(PrintWriter out, RequestContext request, SchemaExporter.Entry entry, String lastEntryPath) {
            super(out, request, entry, lastEntryPath);
            this.schema = entry.getSchema();
            this.namespace = this.schema != null ? this.schema.getTargetNamespace() : null;
        }

        public void visitCheckbox(Template chkbox) {
            if (this.namespace != null) {
                chkbox.accept(this);
            }
        }

        public void visitNamespace(Template ns, Template noNs) {
            if (this.namespace != null) {
                ns.accept(this);
            } else {
                noNs.accept(this);
            }
        }

        public void visitNsPrefix() {
            ((PrintWriter)this.out()).append(this.schema.getNamespacePrefix());
        }

        public void visitNs() {
            ((PrintWriter)this.out()).append(this.namespace);
        }

        public void visitDescription(Template descTemplate) {
            if (this.schema != null && this.schema.getSourceDescription() != null) {
                descTemplate.accept(this);
            }
        }

        public void visitDesc() {
            ((PrintWriter)this.out()).append(this.schema.getSourceDescription());
        }
    }

    private class DirEntryVisitor
    extends AbstractEntryVisitor {
        public DirEntryVisitor(PrintWriter out, RequestContext request, SchemaExporter.Entry entry, String lastEntryPath) {
            super(out, request, entry, lastEntryPath);
        }

        public void visitEntryLink(Template link) {
            FallbackTextWriter v = new FallbackTextWriter(this.out());
            int lastEntryPathLength = 0;
            if (this.lastEntryPath == null) {
                v.context().put("entryUrl", this.request.getResourceURL("/"));
                v.context().put("entryName", "all");
                link.accept(v);
            } else {
                lastEntryPathLength = this.lastEntryPath.length();
            }
            String path = this.entry.getPath();
            int i = path.indexOf("/", lastEntryPathLength);
            while (i >= 0) {
                SchemaExporter.Entry parentEntry = SchemaExporterWEB.this.getEntry(path.substring(0, i + 1));
                v.context().put("entryUrl", this.request.getResourceURL(parentEntry.getPath()));
                v.context().put("entryName", parentEntry.getName().replaceFirst("/$", ""));
                link.accept(v);
                i = path.indexOf("/", i + 1);
            }
        }

        public void visitSubEntries(Template subEntriesTemplate) {
            if (!this.entry.getSubEntries().isEmpty()) {
                subEntriesTemplate.accept(this);
            }
        }

        public void visitSubEntryRecursive(Template dirTemplate, Template fileTemplate) {
            Iterator<SchemaExporter.Entry> i$ = this.entry.getSubEntries().iterator();
            while (i$.hasNext()) {
                SchemaExporter.Entry theOnlySubEntry;
                SchemaExporter.Entry subEntry;
                SchemaExporter.Entry activeEntry = subEntry = i$.next();
                while (activeEntry.isDirectory() && activeEntry.getSubEntries().size() == 1 && (theOnlySubEntry = activeEntry.getSubEntries().iterator().next()).isDirectory()) {
                    activeEntry = theOnlySubEntry;
                }
                if (activeEntry.isDirectory()) {
                    dirTemplate.accept(new DirEntryVisitor((PrintWriter)this.out(), this.request, activeEntry, this.entry.getPath()));
                    continue;
                }
                fileTemplate.accept(new FileEntryVisitor((PrintWriter)this.out(), this.request, activeEntry, this.entry.getPath()));
            }
        }
    }

    private class ListPageVisitor
    extends AbstractEntryVisitor {
        private String contentTypeAndCharset;

        public ListPageVisitor(PrintWriter out, RequestContext request, SchemaExporter.Entry firstEntry, String contentTypeAndCharset) {
            super(out, request, firstEntry, null);
            this.contentTypeAndCharset = contentTypeAndCharset;
        }

        public void visitEntry(Template dirTemplate, Template fileTemplate) {
            if (this.entry.isDirectory()) {
                dirTemplate.accept(new DirEntryVisitor((PrintWriter)this.out(), this.request, this.entry, null));
            } else {
                fileTemplate.accept(new FileEntryVisitor((PrintWriter)this.out(), this.request, this.entry, null));
            }
        }

        public void visitContentTypeAndCharset() {
            ((PrintWriter)this.out()).append(this.contentTypeAndCharset);
        }

        public void visitMenuHead() throws Exception {
            if (SchemaExporterWEB.this.menuProvider != null) {
                SchemaExporterWEB.this.menuProvider.renderMenuHead(this.request);
            }
        }

        public void visitMenu() throws Exception {
            if (SchemaExporterWEB.this.menuProvider != null) {
                SchemaExporterWEB.this.menuProvider.renderMenu(this.request);
            }
        }
    }

    private class AbstractEntryVisitor
    extends TextWriter<PrintWriter> {
        protected final RequestContext request;
        protected final String lastEntryPath;
        protected final SchemaExporter.Entry entry;

        public AbstractEntryVisitor(PrintWriter out, RequestContext request, SchemaExporter.Entry entry, String lastEntryPath) {
            super(out);
            this.request = request;
            this.entry = entry;
            this.lastEntryPath = lastEntryPath;
        }

        public void visitUrl(String relativeUrl) {
            ((PrintWriter)this.out()).print(this.request.getResourceURL(relativeUrl));
        }

        public void visitEntryUrl() {
            ((PrintWriter)this.out()).append(this.request.getResourceURL(this.entry.getPath()));
        }

        public void visitEntryName() {
            ((PrintWriter)this.out()).append(this.entry.getName());
        }

        public void visitEntryClass() {
            if (this.entry.isDirectory()) {
                ((PrintWriter)this.out()).append("directory");
            } else {
                ((PrintWriter)this.out()).append("file");
            }
            if (!this.entry.containsSchemaWithTargetNamespace()) {
                ((PrintWriter)this.out()).append(" no-target-namespace");
            }
        }

        public void visitEntryId() {
            ((PrintWriter)this.out()).append(this.entry.getId());
        }
    }

    public static interface MenuProvider {
        public void renderMenuHead(RequestContext var1) throws Exception;

        public void renderMenu(RequestContext var1) throws Exception;
    }
}

