/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.service.uribroker.uri.WebAppURIBroker;

public class ServletContentURIBroker
extends WebAppURIBroker {
    protected static final int PREFIX_PATH_INDEX = 1;
    protected static final int CONTENT_PATH_INDEX = 2;
    private boolean hasPrefixPath;
    private boolean hasContentPath;

    public String getPrefixPath() {
        if (this.hasPrefixPath) {
            return this.getPathSegmentAsString(1);
        }
        return null;
    }

    public ServletContentURIBroker setPrefixPath(String prefixPath) {
        this.setPathSegment(1, prefixPath);
        this.hasPrefixPath = true;
        return this;
    }

    public String getContentPath() {
        if (this.hasContentPath) {
            return this.getPathSegmentAsString(2);
        }
        return null;
    }

    public ServletContentURIBroker setContentPath(String contentPath) {
        this.setPathSegment(2, contentPath);
        this.hasContentPath = true;
        return this;
    }

    public ServletContentURIBroker getURI(String uri) {
        return this.setContentPath(this.setUriAndGetPath(uri));
    }

    @Override
    protected URIBroker newInstance() {
        return new ServletContentURIBroker();
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof ServletContentURIBroker) {
            ServletContentURIBroker parentContent = (ServletContentURIBroker)parent;
            if (!this.hasPrefixPath) {
                this.hasPrefixPath = parentContent.hasPrefixPath;
                this.setPathSegment(1, parentContent.getPathSegment(1));
            }
            if (!this.hasContentPath) {
                this.hasContentPath = parentContent.hasContentPath;
                this.setPathSegment(2, parentContent.getPathSegment(2));
            }
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof ServletContentURIBroker) {
            ServletContentURIBroker parentContent = (ServletContentURIBroker)parent;
            this.hasPrefixPath = parentContent.hasPrefixPath;
            this.setPathSegment(1, parentContent.getPathSegment(1));
            this.hasContentPath = parentContent.hasContentPath;
            this.setPathSegment(2, parentContent.getPathSegment(2));
        }
    }

    @Override
    protected int getPathSegmentCount() {
        return 3;
    }
}

