/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.impl;

import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.SessionModel;
import com.alibaba.citrus.service.requestcontext.session.impl.SessionImpl;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SessionModelImpl
implements SessionModel {
    private transient SessionConfig sessionConfig;
    private String sessionID;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;

    public SessionModelImpl(SessionImpl session) {
        this.setSession(session);
        this.reset();
    }

    public SessionModelImpl(String sessionID, long creationTime, long lastAccessedTime, int maxInactiveInterval) {
        this.sessionID = sessionID;
        this.creationTime = creationTime;
        this.lastAccessedTime = lastAccessedTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.unexpectedException(e);
            return null;
        }
    }

    private SessionConfig getSessionConfig() {
        return Assert.assertNotNull(this.sessionConfig, "sessionConfig", new Object[0]);
    }

    public void reset() {
        this.getSessionConfig();
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.maxInactiveInterval = this.sessionConfig.getMaxInactiveInterval();
    }

    public void setSession(SessionImpl session) {
        this.sessionConfig = session.getSessionRequestContext().getSessionConfig();
        this.sessionID = session.getId();
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Override
    public boolean isExpired() {
        long expires;
        int maxInactiveInterval = this.getMaxInactiveInterval();
        long forceExpirationPeriod = this.getSessionConfig().getForceExpirationPeriod();
        long current = System.currentTimeMillis();
        if (forceExpirationPeriod > 0L && (expires = this.getCreationTime() + forceExpirationPeriod * 1000L) < current) {
            return true;
        }
        return maxInactiveInterval > 0 && (expires = this.getLastAccessedTime() + (long)(maxInactiveInterval * 1000)) < current;
    }

    public void touch() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        DateFormat fmt = DateFormat.getDateTimeInstance(1, 1, Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        mb.append("sessionID", this.sessionID);
        mb.append("creationTime", this.creationTime <= 0L ? "n/a" : fmt.format(new Date(this.creationTime)));
        mb.append("lastAccessedTime", this.lastAccessedTime <= 0L ? "n/a" : fmt.format(new Date(this.lastAccessedTime)));
        mb.append("maxInactiveInterval", this.maxInactiveInterval);
        return new ToStringBuilder().append("SessionModel").append(mb).toString();
    }
}

