/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.encrypter;

import com.alibaba.citrus.service.requestcontext.session.encoder.SessionEncoderException;
import com.alibaba.citrus.service.requestcontext.session.encrypter.Encrypter;
import com.alibaba.citrus.service.requestcontext.session.encrypter.SessionEncrypterException;
import com.alibaba.citrus.springext.support.BeanSupport;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.Cipher;

public abstract class AbstractJceEncrypter
extends BeanSupport
implements Encrypter {
    public static final int DEFAULT_POOL_SIZE = 256;
    private final Queue<Cipher> eciphers = new ConcurrentLinkedQueue<Cipher>();
    private final Queue<Cipher> dciphers = new ConcurrentLinkedQueue<Cipher>();
    private int poolSize;

    public int getPoolSize() {
        return this.poolSize <= 0 ? 256 : this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    protected final Cipher getCipher(int mode) throws Exception {
        Queue<Cipher> pool = mode == 1 ? this.eciphers : this.dciphers;
        Cipher cipher = pool.poll();
        if (cipher == null) {
            cipher = this.createCipher(mode);
        }
        return cipher;
    }

    protected final void returnCipher(int mode, Cipher cipher) {
        Queue<Cipher> pool;
        Queue<Cipher> queue = pool = mode == 1 ? this.eciphers : this.dciphers;
        if (cipher != null) {
            pool.offer(cipher);
        }
        while (pool.size() > this.getPoolSize()) {
            pool.poll();
        }
    }

    protected abstract Cipher createCipher(int var1) throws Exception;

    @Override
    public byte[] encrypt(byte[] plaintext) throws SessionEncrypterException {
        Cipher cipher = null;
        try {
            cipher = this.getCipher(1);
            byte[] byArray = cipher.doFinal(plaintext);
            return byArray;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to encrypt object", e);
        }
        finally {
            this.returnCipher(1, cipher);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptotext) throws SessionEncrypterException {
        Cipher cipher = null;
        try {
            cipher = this.getCipher(2);
            byte[] byArray = cipher.doFinal(cryptotext);
            return byArray;
        }
        catch (Exception e) {
            throw new SessionEncoderException("Failed to decrypt object", e);
        }
        finally {
            this.returnCipher(2, cipher);
        }
    }
}

