/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteCondition;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteRequestContextFactoryImpl;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteRule;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteSubstitution;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RewriteRequestContextFactoryDefinitionParser
extends AbstractSingleBeanDefinitionParser<RewriteRequestContextFactoryImpl>
implements ContributionAware {
    private ConfigurationPoint rewriteHandlersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.rewriteHandlersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/rewrite/handlers", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> rules = SpringExtUtil.createManagedList(element, parserContext);
        DomUtil.ElementSelector ruleSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("rule"));
        for (Element subElement : DomUtil.subElements(element, ruleSelector)) {
            rules.add(this.parseRule(subElement, parserContext));
        }
        builder.addPropertyValue("rules", rules);
    }

    private BeanDefinition parseRule(Element ruleElement, ParserContext parserContext) {
        BeanDefinitionBuilder ruleBuilder = BeanDefinitionBuilder.genericBeanDefinition(RewriteRule.class);
        SpringExtUtil.attributesToProperties(ruleElement, ruleBuilder, "pattern");
        DomUtil.ElementSelector conditionSelector = DomUtil.and(DomUtil.sameNs(ruleElement), DomUtil.name("condition"));
        DomUtil.ElementSelector substitutionSelector = DomUtil.and(DomUtil.sameNs(ruleElement), DomUtil.name("substitution"));
        DomUtil.ElementSelector handlersSelector = DomUtil.and(DomUtil.sameNs(ruleElement), DomUtil.name("handlers"));
        List<Object> conditions = SpringExtUtil.createManagedList(ruleElement, parserContext);
        BeanDefinition substitution = null;
        List<Object> handlers = null;
        for (Element subElement : DomUtil.subElements(ruleElement)) {
            if (conditionSelector.accept(subElement)) {
                conditions.add(this.parseCondition(subElement, parserContext));
                continue;
            }
            if (substitutionSelector.accept(subElement)) {
                substitution = this.parseSubstitution(subElement, parserContext);
                continue;
            }
            if (!handlersSelector.accept(subElement)) continue;
            handlers = this.parseHandlers(subElement, parserContext, ruleBuilder);
        }
        ruleBuilder.addPropertyValue("conditions", conditions);
        if (substitution != null) {
            ruleBuilder.addPropertyValue("substitution", substitution);
        }
        if (handlers != null) {
            ruleBuilder.addPropertyValue("handlers", handlers);
        }
        return ruleBuilder.getBeanDefinition();
    }

    private BeanDefinition parseCondition(Element conditionElement, ParserContext parserContext) {
        BeanDefinitionBuilder conditionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RewriteCondition.class);
        SpringExtUtil.attributesToProperties(conditionElement, conditionBuilder, "test", "pattern", "flags");
        return conditionBuilder.getBeanDefinition();
    }

    private BeanDefinition parseSubstitution(Element substitutionElement, ParserContext parserContext) {
        BeanDefinitionBuilder substitutionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RewriteSubstitution.class);
        SpringExtUtil.attributesToProperties(substitutionElement, substitutionBuilder, "uri", "flags");
        List<Object> parameters = SpringExtUtil.createManagedList(substitutionElement, parserContext);
        DomUtil.ElementSelector parameterSelector = DomUtil.and(DomUtil.sameNs(substitutionElement), DomUtil.name("parameter"));
        for (Element subElement : DomUtil.subElements(substitutionElement, parameterSelector)) {
            parameters.add(this.parseParameter(subElement, parserContext));
        }
        substitutionBuilder.addPropertyValue("parameters", parameters);
        return substitutionBuilder.getBeanDefinition();
    }

    private BeanDefinition parseParameter(Element parameterElement, ParserContext parserContext) {
        BeanDefinitionBuilder parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(RewriteSubstitution.Parameter.class);
        SpringExtUtil.attributesToProperties(parameterElement, parameterBuilder, "key", "value");
        List<Object> values = SpringExtUtil.createManagedList(parameterElement, parserContext);
        DomUtil.ElementSelector valueSelector = DomUtil.and(DomUtil.sameNs(parameterElement), DomUtil.name("value"));
        for (Element subElement : DomUtil.subElements(parameterElement, valueSelector)) {
            values.add(StringUtil.trimToNull(subElement.getTextContent()));
        }
        if (!values.isEmpty()) {
            parameterBuilder.addPropertyValue("values", values);
        }
        return parameterBuilder.getBeanDefinition();
    }

    private List<Object> parseHandlers(Element handlersElement, ParserContext parserContext, BeanDefinitionBuilder ruleBuilder) {
        List<Object> handlers = SpringExtUtil.createManagedList(handlersElement, parserContext);
        for (Element subElement : DomUtil.subElements(handlersElement)) {
            handlers.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.rewriteHandlersConfigurationPoint, parserContext, ruleBuilder));
        }
        return handlers;
    }
}

