/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;

public class Flags {
    private final String[] flags;

    public Flags() {
        this(null);
    }

    public Flags(String ... flags) {
        this.flags = flags == null ? BasicConstant.EMPTY_STRING_ARRAY : flags;
    }

    public boolean isEmpty() {
        return ArrayUtil.isEmptyArray(this.flags);
    }

    protected String[] getFlags() {
        return this.flags;
    }

    protected boolean hasFlags(String ... names) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(names), "names", new Object[0]);
        for (String flag : this.flags) {
            for (String name : names) {
                if (!flag.startsWith(name) || flag.length() != name.length() && flag.charAt(name.length()) != '=') continue;
                return true;
            }
        }
        return false;
    }

    protected String getFlagValue(String ... names) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(names), "names", new Object[0]);
        for (String flag : this.flags) {
            for (String name : names) {
                if (!flag.startsWith(name)) continue;
                if (flag.length() == name.length()) {
                    return "";
                }
                if (flag.charAt(name.length()) != '=') continue;
                return StringUtil.trimToEmpty(flag.substring(name.length() + 1));
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder.CollectionBuilder().setOneLine(true).appendAll(this.flags).toString();
    }
}

