/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pull.impl;

import com.alibaba.citrus.service.pull.impl.PullServiceImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PullServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<PullServiceImpl>
implements ContributionAware {
    private static final Logger log = LoggerFactory.getLogger(PullServiceDefinitionParser.class);
    private static final Pattern ID_PATTERN = Pattern.compile("\\w+");
    private static final String[] CLASS_NAME_SUFFIXES = new String[]{"Tool", "ToolFactory", "ToolSet", "ToolSetFactory"};
    private static final String[] ELEMENT_NAME_SUFFIXES = new String[]{"-tool", "-tool-factory", "-tool-set", "-tool-set-factory"};
    private ConfigurationPoint pullToolsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.pullToolsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/pull/factories", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        Map<Object, Object> factories = SpringExtUtil.createManagedMap(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            this.doParseTool(subElement, parserContext, builder, factories);
        }
        log.debug("Totally {} tools are registered.", (Object)factories.size());
        builder.addPropertyValue("toolFactories", factories);
        String parentRef = StringUtil.trimToNull(element.getAttribute("parentRef"));
        if (parentRef != null) {
            builder.addPropertyValue("parent", (Object)new RuntimeBeanReference(parentRef));
        }
    }

    private void doParseTool(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, Map<Object, Object> factories) {
        BeanDefinitionHolder bean = SpringExtUtil.parseConfigurationPointBean(element, this.pullToolsConfigurationPoint, parserContext, builder);
        if (bean == null) {
            return;
        }
        String refName = StringUtil.trimToNull(element.getAttribute("ref"));
        String toolName = this.getToolName(bean, refName, element);
        Assert.assertNotNull(toolName, "missing id for tool: %s", bean);
        Assert.assertTrue(!factories.containsKey(toolName), "duplicated tool or tool-set ID: %s", toolName);
        factories.put(toolName, bean);
        if (log.isDebugEnabled()) {
            String targetBeanClass = bean.getBeanDefinition().getBeanClassName();
            if (refName != null) {
                log.debug("Registered tool reference: {}={}", (Object)toolName, (Object)refName);
            } else {
                log.debug("Registered tool: {}={}", (Object)toolName, (Object)targetBeanClass);
            }
        }
    }

    private String getToolName(BeanDefinitionHolder bean, String refName, Element element) {
        BeanDefinition bd;
        String className;
        String classAttr;
        String toolName = bean.getBeanName();
        if (!ID_PATTERN.matcher(toolName).matches()) {
            toolName = null;
        }
        if (toolName == null) {
            toolName = refName;
        }
        if (toolName == null && (classAttr = StringUtil.trimToNull(element.getAttribute("class"))) != null) {
            toolName = this.className2ToolName(classAttr);
        }
        String elementName = element.getLocalName();
        if (toolName == null && elementName != null && !elementName.equals("factory")) {
            toolName = this.dropSuffix(elementName, ELEMENT_NAME_SUFFIXES);
            toolName = StringUtil.trimToNull(StringUtil.toCamelCase(toolName.replace('-', '_')));
        }
        if (toolName == null && (className = (bd = bean.getBeanDefinition()).getBeanClassName()) != null) {
            toolName = this.className2ToolName(className);
        }
        return toolName;
    }

    private String className2ToolName(String className) {
        String toolName = className.substring(className.lastIndexOf(".") + 1);
        toolName = this.dropSuffix(toolName, CLASS_NAME_SUFFIXES);
        toolName = StringUtil.toCamelCase(toolName.substring(toolName.lastIndexOf("$") + 1));
        return toolName;
    }

    private String dropSuffix(String name, String[] suffixes) {
        String tmp = "";
        for (String suffix : suffixes) {
            if (!name.endsWith(suffix)) continue;
            tmp = name.substring(0, name.length() - suffix.length());
        }
        return tmp.length() > 0 ? tmp : name;
    }

    @Override
    protected String getDefaultName() {
        return "pullService";
    }
}

