/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Condition;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.impl.valve.BreakValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class BreakUnlessValve
extends BreakValve {
    private Condition condition;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        Assert.assertNotNull(this.condition, "no condition", new Object[0]);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        if (!this.condition.isSatisfied(pipelineContext)) {
            super.invoke(pipelineContext);
        }
        pipelineContext.invokeNext();
    }

    @Override
    public String toString() {
        return "BreakUnlessValve[" + this.parametersToString() + ", unless " + this.condition + "]";
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<BreakUnlessValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "levels", "toLabel");
            Object condition = this.parseCondition(element, parserContext, builder);
            if (condition != null) {
                builder.addPropertyValue("condition", condition);
            }
        }
    }
}

