/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.factory;

import com.alibaba.citrus.service.moduleloader.impl.ModuleKey;
import com.alibaba.citrus.service.moduleloader.impl.factory.ModuleInfo;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.w3c.dom.Element;

public abstract class AbstractModuleFactoryDefinitionParser<T>
extends AbstractNamedBeanDefinitionParser<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getBeanClass(null));

    protected final Map<String, ParsingModuleInfo> parseSpecificBeans(Element element, ParserContext parserContext, AbstractBeanDefinition containingBd, DomUtil.ElementSelector beanSelector) {
        HashMap<String, ParsingModuleInfo> specificBeans = CollectionUtil.createHashMap();
        for (Element subElement : DomUtil.subElements(element, beanSelector)) {
            BeanDefinitionHolder bdh = (BeanDefinitionHolder)parserContext.getDelegate().parsePropertySubElement(subElement, (BeanDefinition)containingBd);
            String itemName = this.parseItemName(parserContext, subElement, bdh.getBeanDefinition());
            specificBeans.put(itemName, new ParsingModuleInfo(bdh.getBeanDefinition(), itemName));
        }
        this.log.debug("Found {} specificly defined modules", (Object)specificBeans.size());
        return specificBeans;
    }

    protected abstract String parseItemName(ParserContext var1, Element var2, BeanDefinition var3);

    protected BeanDefinitionDefaults getBeanDefinitionDefaults(Element element, ParserContext parserContext) {
        BeanDefinitionDefaults defaults = new BeanDefinitionDefaults();
        String defaultLazyInit = StringUtil.trimToNull(element.getAttribute("defaultLazyInit"));
        String defaultAutowireMode = StringUtil.trimToNull(element.getAttribute("defaultAutowireMode"));
        if (defaultLazyInit == null) {
            defaults.setLazyInit(this.getDefaultLazyInit());
        } else {
            defaults.setLazyInit(Boolean.parseBoolean(defaultLazyInit));
        }
        if (defaultAutowireMode == null) {
            defaultAutowireMode = this.getDefaultAutowireMode();
        }
        defaults.setAutowireMode(parserContext.getDelegate().getAutowireMode(defaultAutowireMode));
        return defaults;
    }

    protected boolean getDefaultLazyInit() {
        return false;
    }

    protected String getDefaultAutowireMode() {
        return "no";
    }

    protected void postProcessItems(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, Map<String, ParsingModuleInfo> items, String tags) {
        for (ParsingModuleInfo item : items.values()) {
            if (item.bd == null) continue;
            Assert.assertNotNull(item.key, "Specificly-defined module could not be found in %s: %s", tags, item.itemName);
            item.beanName = SpringExtUtil.generateBeanName(item.getBaseBeanName(), parserContext.getRegistry());
            parserContext.getRegistry().registerBeanDefinition(item.beanName, item.bd);
        }
        List<Object> moduleList = SpringExtUtil.createManagedList(element, parserContext);
        this.log.debug("Defined {} modules with {}", (Object)items.size(), (Object)this.getBeanClass(null).getSimpleName());
        for (ParsingModuleInfo item : items.values()) {
            if (item.beanName == null) continue;
            BeanDefinitionBuilder bdb = BeanDefinitionBuilder.genericBeanDefinition(ModuleInfo.class);
            bdb.addConstructorArgValue((Object)item.key);
            bdb.addConstructorArgValue((Object)item.beanName);
            bdb.addConstructorArgValue((Object)item.itemName);
            moduleList.add(bdb.getBeanDefinition());
            this.log.debug("Defined module {} with {}", new Object[]{item.key, item.itemName});
        }
        builder.addPropertyValue("modules", moduleList);
    }

    protected static class ParsingModuleInfo {
        final BeanDefinition bd;
        final String itemName;
        String beanName;
        ModuleKey key;

        public ParsingModuleInfo(String moduleType, String moduleName, String itemName) {
            this.bd = null;
            this.key = new ModuleKey(moduleType, moduleName);
            this.itemName = itemName;
        }

        public ParsingModuleInfo(BeanDefinition bd, String itemName) {
            this.bd = bd;
            this.itemName = itemName;
        }

        public String getBaseBeanName() {
            return "module." + this.key.getModuleType() + "." + this.key.getModuleName();
        }
    }

    protected static class ParsingModuleMatcher {
        private final Map<String, ParsingModuleInfo> items;
        private final Pattern itemPattern;
        private final String typeName;
        private final String moduleName;
        private List<TypeFilter> includeFilters;

        public ParsingModuleMatcher(Map<String, ParsingModuleInfo> items, Pattern itemPattern, String typeName, String moduleName) {
            this(items, itemPattern, typeName, moduleName, null);
        }

        public ParsingModuleMatcher(Map<String, ParsingModuleInfo> items, Pattern itemPattern, String typeName, String moduleName, List<TypeFilter> includeFilters) {
            this.items = items;
            this.itemPattern = itemPattern;
            this.typeName = typeName;
            this.moduleName = moduleName;
            this.includeFilters = includeFilters;
        }

        protected boolean doMatch(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            String itemName = metadataReader.getAnnotationMetadata().getClassName();
            Matcher matcher = this.itemPattern.matcher(itemName);
            if (!matcher.find()) {
                return false;
            }
            boolean matched = true;
            if (this.includeFilters != null) {
                matched = this.includeFilters.size() < 1;
                for (TypeFilter filter : this.includeFilters) {
                    if (matched) break;
                    try {
                        matched = filter.match(metadataReader, metadataReaderFactory);
                    }
                    catch (Exception e) {
                        matched = false;
                    }
                }
            }
            if (!matched) {
                return false;
            }
            return this.match(itemName, matcher);
        }

        protected final boolean doMatch(String itemName) {
            Matcher matcher = this.itemPattern.matcher(itemName);
            if (!matcher.find()) {
                return false;
            }
            return this.match(itemName, matcher);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean match(String itemName, Matcher matcher) {
            String name;
            MatchResultSubstitution subs = new MatchResultSubstitution(matcher);
            String type = StringUtil.trimToNull(subs.substitute(this.typeName));
            if (type == null) {
                return false;
            }
            if (this.moduleName == null) {
                int startIndex = subs.getMatch().end() + 1;
                if (itemName.length() <= startIndex) return false;
                name = itemName.substring(startIndex);
            } else {
                name = subs.substitute(this.moduleName);
            }
            name = this.getName(name, itemName);
            if (this.items.containsKey(itemName)) {
                ParsingModuleInfo item = this.items.get(itemName);
                if (item.bd == null || item.key != null) return false;
                item.key = new ModuleKey(type, name);
                return false;
            }
            this.items.put(itemName, new ParsingModuleInfo(type, name, itemName));
            return true;
        }

        protected String getName(String name, String itemName) {
            return name;
        }

        protected final String generateBeanName(String itemName, BeanDefinitionRegistry registry) {
            ParsingModuleInfo item = Assert.assertNotNull(this.items.get(itemName), "missing %s", itemName);
            item.beanName = SpringExtUtil.generateBeanName(item.getBaseBeanName(), registry);
            return item.beanName;
        }
    }
}

