/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.impl.rule;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

abstract class FallbackIterator
implements Iterator<String> {
    private static final int STATE_SPECIFIC_NAME = 0;
    private static final int STATE_DEFAULT_NAME = 1;
    private static final int STATE_FINAL_NAME = 2;
    private final String name;
    private final List<String> names;
    private final String defaultLastName;
    private final String finalName;
    private final boolean matchLastName;
    private String lastName;
    private String fullName;
    private int state;

    public FallbackIterator(String name, String defaultLastName, String finalName, boolean matchLastName) {
        String[] parts = StringUtil.split(StringUtil.trimToNull(name), ",/");
        if (ArrayUtil.isEmptyArray(parts)) {
            this.invalidName(name);
        }
        this.name = name;
        this.defaultLastName = defaultLastName;
        this.names = CollectionUtil.createArrayList(parts);
        this.finalName = finalName;
        this.matchLastName = matchLastName;
        this.state = 0;
    }

    protected void init() {
        if (this.lastName == null) {
            this.lastName = this.normalizeLastName(this.names.get(this.names.size() - 1));
            if (this.lastName == null) {
                this.invalidName(this.name);
            }
            this.setFullName(this.lastName);
        }
    }

    public final String getLastName() {
        this.init();
        return this.lastName;
    }

    public final String getNext() {
        if (this.hasNext()) {
            return this.fullName;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final boolean hasNext() {
        this.init();
        if (this.fullName != null) {
            return true;
        }
        switch (this.state) {
            case 1: {
                if (this.names.size() <= 1) {
                    this.state = 2;
                    if (this.finalName != null) {
                        this.fullName = this.finalName;
                        return true;
                    }
                    return false;
                }
                this.names.remove(this.names.size() - 1);
                if (this.matchLastName) {
                    this.setFullName(this.lastName);
                    this.state = 0;
                } else {
                    this.setFullName(this.defaultLastName);
                    this.state = 1;
                }
                return true;
            }
            case 0: {
                this.setFullName(this.defaultLastName);
                this.state = 1;
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private void setFullName(String lastName) {
        this.names.set(this.names.size() - 1, lastName);
        this.fullName = this.generateFullName(this.names);
    }

    @Override
    public final String next() {
        if (this.hasNext()) {
            String result = this.fullName;
            this.fullName = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public List<String> getNames() {
        return this.names;
    }

    protected abstract void invalidName(String var1);

    protected abstract String normalizeLastName(String var1);

    protected abstract String generateFullName(List<String> var1);
}

