/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.session;

import com.alibaba.citrus.service.mail.MailException;
import com.alibaba.citrus.service.mail.MailNotFoundException;
import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.service.mail.MailStoreNotFoundException;
import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.session.MailSession;
import com.alibaba.citrus.service.mail.session.MailStore;
import com.alibaba.citrus.service.mail.session.MailTransportHandler;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Transport;
import javax.mail.event.TransportListener;

public class MailTransport
extends MailSession {
    private String transportProtocol;
    private String popBeforeSmtpId;
    private MailTransportHandler handler;
    private Transport transport;

    public MailTransport() {
    }

    public MailTransport(MailTransport transport, Properties overrideProps) {
        super(transport, overrideProps);
        this.transportProtocol = transport.transportProtocol;
        this.popBeforeSmtpId = transport.popBeforeSmtpId;
    }

    public String getProtocol() {
        return ObjectUtil.defaultIfNull(this.transportProtocol, "smtp");
    }

    public void setProtocol(String protocol) {
        this.transportProtocol = StringUtil.trimToNull(protocol);
    }

    public String getPopBeforeSmtp() {
        return this.popBeforeSmtpId;
    }

    public void setPopBeforeSmtp(String popBeforeSmtpId) {
        this.popBeforeSmtpId = StringUtil.trimToNull(popBeforeSmtpId);
    }

    @Override
    protected Properties getSessionProperties() {
        this.setProperty("mail.smtp.auth", String.valueOf(this.useAuth()), "false");
        return super.getSessionProperties();
    }

    public MailTransportHandler getHandler() {
        return this.handler;
    }

    public void setHandler(MailTransportHandler newHandler) {
        if (this.handler != null && this.transport != null) {
            this.transport.removeTransportListener((TransportListener)this.handler);
        }
        if (newHandler != null) {
            this.handler = newHandler;
        }
        if (this.handler != null && this.transport != null) {
            this.transport.addTransportListener((TransportListener)this.handler);
        }
    }

    @Override
    public boolean isConnected() {
        return this.transport != null && this.transport.isConnected();
    }

    @Override
    public void connect() throws MailException {
        if (!this.isConnected()) {
            try {
                this.transport = this.getSession().getTransport(this.getProtocol());
                this.setHandler(null);
                this.connectPopBeforeSmtp();
                this.transport.connect(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
                if (this.getHandler() != null) {
                    this.getHandler().prepareConnection(this.transport);
                }
            }
            catch (NoSuchProviderException e) {
                this.transport = null;
                throw new MailException("Could not find a provider of " + this.getProtocol() + " protocol", e);
            }
            catch (MessagingException me) {
                this.transport = null;
                throw new MailException("Could not connect to the transport", me);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MailException {
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (MessagingException messagingException) {
            }
            finally {
                this.transport = null;
            }
        }
    }

    public void send(String mailId) throws MailException {
        this.send(mailId, null);
    }

    public void send(String mailId, MailTransportHandler handler) throws MailException {
        MailService service = this.getMailService();
        if (service == null) {
            throw new MailNotFoundException("Could not find mail \"" + mailId + "\": mail service is not set");
        }
        MailBuilder builder = service.getMailBuilder(mailId);
        this.send(builder, handler);
    }

    public void send(MailBuilder builder) throws MailException {
        this.send(builder, null);
    }

    public void send(MailBuilder builder, MailTransportHandler handler) throws MailException {
        this.setHandler(handler);
        if (this.getHandler() != null) {
            this.getHandler().prepareMessage(builder);
        }
        this.send((Message)builder.getMessage(this.getSession()), this.getHandler());
    }

    public void send(Message message) throws MailException {
        this.send(message, null);
    }

    public void send(Message message, MailTransportHandler handler) throws MailException {
        boolean autoClose = false;
        this.setHandler(handler);
        if (!this.isConnected()) {
            autoClose = true;
            this.connect();
        }
        try {
            message.setSentDate(new Date());
            if (this.getHandler() != null) {
                this.getHandler().processMessage(message);
            }
            message.saveChanges();
            Address[] recipients = message.getAllRecipients();
            if (ArrayUtil.isEmptyArray(recipients)) {
                throw new MailException("No recipient was specified in mail");
            }
            this.transport.sendMessage(message, recipients);
        }
        catch (MessagingException me) {
            throw new MailException("Could not send message", me);
        }
        finally {
            if (autoClose) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectPopBeforeSmtp() throws MailException {
        if (this.popBeforeSmtpId != null) {
            MailService service = this.getMailService();
            if (service == null) {
                throw new MailStoreNotFoundException("Could not find mail store \"" + this.popBeforeSmtpId + "\": mail service is not set");
            }
            MailStore popBeforeSmtpStore = Assert.assertNotNull(service.getMailStore(this.popBeforeSmtpId), "popBeforeSmtpStore: %s", this.popBeforeSmtpId);
            try {
                popBeforeSmtpStore.connect();
            }
            finally {
                popBeforeSmtpStore.close();
            }
        }
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("protocol", this.getProtocol());
        mb.append("popBeforeSmtp", this.getPopBeforeSmtp());
    }
}

