/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.session;

import com.alibaba.citrus.service.mail.MailException;
import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;

public abstract class MailSession {
    private final Properties props = new Properties();
    private MailService mailService;
    private Session session;
    private String host;
    private int port;
    private String user;
    private String password;
    private boolean debug;
    private boolean defaultSession;

    public MailSession() {
    }

    public MailSession(MailSession session, Properties overrideProps) {
        this.mailService = session.mailService;
        this.session = session.getSession();
        this.host = session.host;
        this.port = session.port;
        this.user = session.user;
        this.password = session.password;
        this.debug = session.debug;
        this.defaultSession = false;
        this.props.putAll((Map<?, ?>)session.props);
        if (overrideProps != null) {
            for (Object element : overrideProps.keySet()) {
                String key = (String)element;
                String value = overrideProps.getProperty(key);
                this.setProperty(key, value, null);
            }
        }
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = StringUtil.trimToNull(host);
    }

    public int getPort() {
        return this.port > 0 ? this.port : -1;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean useAuth() {
        return this.user != null;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = StringUtil.trimToNull(user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtil.trimToNull(password);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDefault() {
        return this.defaultSession;
    }

    public void setDefault(boolean defaultSession) {
        this.defaultSession = defaultSession;
    }

    public void setProperties(Map<String, String> props) {
        if (props != null) {
            this.props.clear();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = Assert.assertNotNull(StringUtil.trimToNull(entry.getKey()), "propertyName", new Object[0]);
                String value = StringUtil.trimToNull(entry.getValue());
                this.setProperty(key, value);
            }
        }
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, null);
    }

    protected final void setProperty(String key, String value, String defaultValue) {
        String currentValue = this.props.getProperty(key, defaultValue);
        if (!ObjectUtil.isEquals(currentValue, value)) {
            this.props.setProperty(key, value);
            this.session = null;
        }
    }

    protected Properties getSessionProperties() {
        this.setProperty("mail.debug", String.valueOf(this.isDebug()), "false");
        return this.props;
    }

    protected synchronized Session getSession() {
        Properties props = this.getSessionProperties();
        if (this.session == null) {
            this.session = Session.getInstance((Properties)props);
        }
        return this.session;
    }

    protected abstract boolean isConnected();

    protected abstract void connect() throws MailException;

    protected abstract void close() throws MailException;

    public final String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true);
        mb.append("host", this.getHost());
        mb.append("port", this.getPort());
        mb.append("user", this.getUser());
        mb.append("password", this.getPassword());
        mb.append("debug", this.isDebug());
        mb.append("default", this.isDefault());
        mb.append("otherProperties", this.props);
        this.toString(mb);
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }

    protected abstract void toString(ToStringBuilder.MapBuilder var1);
}

