/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.builder.content.TemplateContent;
import com.alibaba.citrus.service.mail.util.MailUtil;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

public class TextTemplateContent
extends TemplateContent {
    public TextTemplateContent() {
    }

    public TextTemplateContent(String templateName) {
        this.setTemplate(templateName);
    }

    public TextTemplateContent(String templateName, String contentType) {
        this.setTemplate(templateName);
        this.setContentType(contentType);
    }

    @Override
    public void render(Part mailPart) throws MessagingException {
        String text = this.renderTemplate();
        String contentType = this.getContentType();
        ContentType contentTypeObject = MailUtil.getContentType(contentType, this.getMailBuilder().getCharacterEncoding());
        mailPart.setContent((Object)text, contentTypeObject.toString());
        mailPart.setHeader("Content-Transfer-Encoding", "8bit");
    }

    @Override
    protected TextTemplateContent newInstance() {
        return new TextTemplateContent();
    }
}

