/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.MailNotFoundException;
import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.builder.MailBuilderException;
import com.alibaba.citrus.service.mail.builder.content.AbstractContent;
import com.alibaba.citrus.service.mail.support.ResourceDataSource;
import com.alibaba.citrus.service.mail.util.MailUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AttachmentContent
extends AbstractContent
implements ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private AttachmentSource source;
    private String fileName;

    public AttachmentContent() {
    }

    public AttachmentContent(URL attachmentURL) {
        this.setURL(attachmentURL);
    }

    public AttachmentContent(URL attachmentURL, String fileName) {
        this.setURL(attachmentURL);
        this.setFileName(fileName);
    }

    public AttachmentContent(File attachmentFile) {
        this.setFile(attachmentFile);
    }

    public AttachmentContent(File attachmentFile, String fileName) {
        this.setFile(attachmentFile);
        this.setFileName(fileName);
    }

    public AttachmentContent(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public AttachmentContent(DataSource dataSource, String fileName) {
        this.setDataSource(dataSource);
        this.setFileName(fileName);
    }

    public AttachmentContent(String resourceName) {
        this.setResource(resourceName);
    }

    public AttachmentContent(String resourceName, String fileName) {
        this.setResource(resourceName);
        this.setFileName(fileName);
    }

    public AttachmentContent(MailBuilder mailBuilder) {
        this.setMail(mailBuilder);
    }

    public AttachmentContent(Message mail) {
        this.setMail(mail);
    }

    public void setURL(URL attachmentURL) {
        this.setSource(new URLSource(this, attachmentURL));
    }

    public void setFile(File attachmentFile) {
        this.setSource(new FileSource(this, attachmentFile));
    }

    public void setDataSource(DataSource dataSource) {
        this.setSource(new DsSource(this, dataSource));
    }

    public void setResource(String resourceName) {
        this.setSource(new ResourceSource(this, resourceName));
        this.source.containingContent = this;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setFileName(String fileName) {
        this.fileName = StringUtil.trimToNull(fileName);
    }

    public void setMail(MailBuilder mailBuilder) {
        this.setSource(new MailBuilderSource(this, mailBuilder));
    }

    public void setMail(Message mail) {
        this.setSource(new MailSource(this, mail));
    }

    public void setMail(String attachmentRefId) {
        this.setSource(new MailRefSource(this, attachmentRefId));
    }

    private void setSource(AttachmentSource source) {
        Assert.assertNull(this.source, Assert.ExceptionType.ILLEGAL_STATE, "Attachment source already set: %s", this.source);
        this.source = Assert.assertNotNull(source, "source", new Object[0]);
    }

    @Override
    public void render(Part mailPart) throws MessagingException {
        Assert.assertNotNull(this.source, "No attachment source was specified", new Object[0]);
        this.source.render(mailPart, this.fileName);
    }

    @Override
    protected AttachmentContent newInstance() {
        return new AttachmentContent();
    }

    @Override
    protected void copyTo(AbstractContent copy) {
        AttachmentContent copyContent = (AttachmentContent)copy;
        if (this.source != null) {
            copyContent.source = this.source.clone();
            copyContent.source.containingContent = copyContent;
        }
        copyContent.resourceLoader = this.resourceLoader;
        copyContent.fileName = this.fileName;
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        mb.append("source", this.source);
        mb.append("fileName", this.fileName);
    }

    private static class MailRefSource
    extends AttachmentSource {
        private String mailRef;

        public MailRefSource(AttachmentContent containingContent, String mailRef) {
            super(containingContent);
            this.mailRef = Assert.assertNotNull(StringUtil.trimToNull(mailRef), "mailRef", new Object[0]);
        }

        @Override
        protected String name() {
            return "MailRef";
        }

        @Override
        protected String desc() {
            return this.mailRef;
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            MailBuilder mailBuilder;
            MailService mailService = this.getMailBuilder().getMailService();
            if (mailService == null) {
                throw new MailBuilderException("Could not find mail \"" + this.mailRef + "\": no MailService");
            }
            try {
                mailBuilder = mailService.getMailBuilder(this.mailRef);
            }
            catch (MailNotFoundException e) {
                throw new MailBuilderException("Could not find mail \"" + this.mailRef + "\"", e);
            }
            MimeMessage mail = mailBuilder.getMessage(this.getMailBuilder().getSession());
            this.render(mailPart, (Message)mail);
        }
    }

    private static class MailSource
    extends AttachmentSource {
        private Message mail;

        public MailSource(AttachmentContent containingContent, Message mail) {
            super(containingContent);
            this.mail = Assert.assertNotNull(mail, "mail", new Object[0]);
        }

        @Override
        protected String name() {
            return "Message";
        }

        @Override
        protected String desc() {
            return this.mail.getClass().getSimpleName();
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            this.render(mailPart, this.mail);
        }
    }

    private static class MailBuilderSource
    extends AttachmentSource {
        private MailBuilder mailBuilder;

        public MailBuilderSource(AttachmentContent containingContent, MailBuilder mailBuilder) {
            super(containingContent);
            this.mailBuilder = Assert.assertNotNull(mailBuilder, "mailBuilder", new Object[0]);
        }

        @Override
        protected String name() {
            return "MailBuilder";
        }

        @Override
        protected String desc() {
            return "id=" + this.mailBuilder.getId();
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            MimeMessage mail = this.mailBuilder.getMessage(this.getMailBuilder().getSession());
            this.render(mailPart, (Message)mail);
        }
    }

    private static class ResourceSource
    extends AttachmentSource {
        private String resourceName;

        public ResourceSource(AttachmentContent containingContent, String resourceName) {
            super(containingContent);
            this.resourceName = Assert.assertNotNull(StringUtil.trimToNull(resourceName), "resourceName", new Object[0]);
        }

        @Override
        protected String name() {
            return "Resource";
        }

        @Override
        protected String desc() {
            return this.resourceName;
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            Object ds;
            ResourceLoader resourceLoader = this.containingContent.getResourceLoader();
            if (resourceLoader == null) {
                throw new MailBuilderException("Could not find resource \"" + this.resourceName + "\": no resourceLoader specified");
            }
            Resource resource = resourceLoader.getResource(this.resourceName);
            if (!resource.exists()) {
                throw new MailBuilderException("Could not find resource \"" + this.resourceName + "\"");
            }
            try {
                ds = new URLDataSource(resource.getURL());
            }
            catch (IOException e) {
                ds = new ResourceDataSource(resource);
            }
            if (fileName == null) {
                fileName = this.resourceName;
            }
            this.render(mailPart, fileName, (DataSource)ds);
        }
    }

    private static class DsSource
    extends AttachmentSource {
        private DataSource dataSource;

        public DsSource(AttachmentContent containingContent, DataSource dataSource) {
            super(containingContent);
            this.dataSource = Assert.assertNotNull(dataSource, "dataSource", new Object[0]);
        }

        @Override
        protected String name() {
            return "DataSource";
        }

        @Override
        protected String desc() {
            return this.dataSource.toString();
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            if (fileName == null) {
                fileName = this.dataSource.getName();
            }
            this.render(mailPart, fileName, this.dataSource);
        }
    }

    private static class FileSource
    extends AttachmentSource {
        private File file;

        public FileSource(AttachmentContent containingContent, File file) {
            super(containingContent);
            this.file = Assert.assertNotNull(file, "file", new Object[0]);
        }

        @Override
        protected String name() {
            return "File";
        }

        @Override
        protected String desc() {
            return this.file.getAbsolutePath();
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            FileDataSource ds = new FileDataSource(this.file);
            if (fileName == null) {
                fileName = this.file.getAbsolutePath();
            }
            this.render(mailPart, fileName, (DataSource)ds);
        }
    }

    private static class URLSource
    extends AttachmentSource {
        private URL url;

        public URLSource(AttachmentContent containingContent, URL url) {
            super(containingContent);
            this.url = Assert.assertNotNull(url, "url", new Object[0]);
        }

        @Override
        protected String name() {
            return "URL";
        }

        @Override
        protected String desc() {
            return this.url.toExternalForm();
        }

        @Override
        protected void render(Part mailPart, String fileName) {
            URLDataSource ds = new URLDataSource(this.url);
            if (fileName == null) {
                fileName = this.url.getPath();
            }
            this.render(mailPart, fileName, (DataSource)ds);
        }
    }

    private static abstract class AttachmentSource
    implements Cloneable {
        protected transient AttachmentContent containingContent;

        public AttachmentSource(AttachmentContent containingContent) {
            this.containingContent = Assert.assertNotNull(containingContent, "containingContent", new Object[0]);
        }

        public final MailBuilder getMailBuilder() {
            return this.containingContent.getMailBuilder();
        }

        public final String toString() {
            return this.name() + "[" + this.desc() + "]";
        }

        protected abstract String name();

        protected abstract String desc();

        protected abstract void render(Part var1, String var2);

        protected final void render(Part mailPart, String fileName, DataSource source) throws MailBuilderException {
            try {
                mailPart.setDataHandler(new DataHandler(source));
                if (StringUtil.isEmpty(fileName)) {
                    throw new MailBuilderException("No fileName was specified with " + this);
                }
                fileName = fileName.replace('\\', '/');
                fileName = StringUtil.defaultIfEmpty(StringUtil.substringAfterLast(fileName, "/"), fileName);
                mailPart.setFileName(MailUtil.encodeHeader(fileName, this.getMailBuilder().getCharacterEncoding()));
            }
            catch (MessagingException e) {
                throw new MailBuilderException("Failed to add attachment to the mail", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new MailBuilderException("Failed to add attachment to the mail", e);
            }
        }

        protected final void render(Part mailPart, Message mail) throws MailBuilderException {
            try {
                mailPart.setContent((Object)mail, "message/rfc822");
                String subject = mail.getSubject();
                if (!StringUtil.isEmpty(subject)) {
                    mailPart.setDescription(MailUtil.encodeHeader(subject, this.getMailBuilder().getCharacterEncoding()));
                }
            }
            catch (MessagingException e) {
                throw new MailBuilderException("Failed to add attachment to the mail", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new MailBuilderException("Failed to add attachment to the mail", e);
            }
        }

        public final AttachmentSource clone() {
            try {
                return (AttachmentSource)super.clone();
            }
            catch (CloneNotSupportedException e) {
                Assert.unexpectedException(e);
                return null;
            }
        }
    }
}

