/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.freemarker.impl;

import com.alibaba.citrus.service.freemarker.impl.FreeMarkerEngineImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FreeMarkerEngineDefinitionParser
extends AbstractSingleBeanDefinitionParser<FreeMarkerEngineImpl>
implements ContributionAware {
    private ConfigurationPoint pluginsConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.pluginsConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/template/engines/freemarker/plugins", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.attributesToProperties(element, "configuration.", builder, "path", "templateEncoding");
        DomUtil.ElementSelector plugins = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("plugins"));
        DomUtil.ElementSelector advancedProperties = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("advanced-properties"));
        for (Element subElement : DomUtil.subElements(element)) {
            if (plugins.accept(subElement)) {
                this.parsePlugins(subElement, parserContext, builder);
                continue;
            }
            if (!advancedProperties.accept(subElement)) continue;
            this.parseAdvancedProperties(subElement, parserContext, builder);
        }
    }

    private void parsePlugins(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List<Object> plugins = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            plugins.add(SpringExtUtil.parseConfigurationPointBean(subElement, this.pluginsConfigurationPoint, parserContext, builder));
        }
        builder.addPropertyValue("configuration.plugins", plugins);
    }

    private void parseAdvancedProperties(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map<Object, Object> props = SpringExtUtil.createManagedMap(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("property")))) {
            String name = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("name")), "propertyName", new Object[0]);
            String value = StringUtil.trimToEmpty(subElement.getAttribute("value"));
            props.put(name, value);
        }
        builder.addPropertyValue("configuration.advancedProperties", props);
    }
}

